/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.cli;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.ui.preferences.CFileTypeAssociation;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.nativecore.cli.BuildStepSetter;
import org.tizen.nativecore.cli.Messages;
import org.tizen.nativecore.cli.ReferenceFlagSetter;
import org.tizen.nativecore.cli.ResourceFilterSetter;
import org.tizen.nativecore.cli.ToolFlagSetter;
import org.tizen.nativecore.cli.model.FlagsFile;
import org.tizen.nativecore.cli.model.PrePostFile;
import org.tizen.nativecore.cli.model.ProjectDefFile;

public class ExportCLIProjectAction
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    private List<IProject> selectedProjects = new ArrayList<IProject>();
    private ICSourceEntry[] srcEntries;
    private Set<IResource> resources;
    private static final String BUILD_DIR = "Build";
    private static final String PROJDEF_FILENAME = "project_def.prop";
    private static final String TOOLFLAG_FILENAME = "flags.mk";
    private static final String BUILDDEF_FILENAME = "build_def.prop";
    private static final String MAKEFILE_DIR = "Template/Common/Build Script/Build";
    static int countSucc;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void run(IAction action) {
        final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (this.selectedProjects.size() == 0) {
            DialogUtil.openErrorDialog((Shell)window.getShell(), (String)Messages.FAILED_TO_CONVERT, (String)(String.valueOf(Messages.FAILED_TO_CONVERT) + "\n - " + Messages.PROJECT_NOT_SET));
            return;
        }
        String msg = this.getDlgMsgIfNeedToOverwrite();
        if (msg != null && !MessageDialog.openConfirm((Shell)window.getShell(), (String)Messages.OVERWRITE_DLG_TITLE, (String)msg)) {
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            countSucc = 0;
                            monitor.beginTask(Messages.PROGRESS_MAIN, 9 * ExportCLIProjectAction.this.selectedProjects.size());
                            for (IProject project : ExportCLIProjectAction.this.selectedProjects) {
                                String projName = project.getName();
                                ExportCLIProjectAction.this.resources = new HashSet();
                                ProjectDefFile projDefFile = new ProjectDefFile();
                                FlagsFile flagFile = new FlagsFile();
                                PrePostFile prepostFile = new PrePostFile();
                                IConfiguration config = NativeCoreConfigurationManager.getDefaultConfiguration((IProject)project);
                                monitor.subTask(String.format(Messages.PROGRESS_STEP1, projName));
                                ExportCLIProjectAction.this.setAppName(project, projDefFile);
                                ExportCLIProjectAction.this.setAppType(project, projDefFile);
                                ExportCLIProjectAction.this.setAppProfile(project, projDefFile);
                                ExportCLIProjectAction.this.setSourceList(project, projDefFile, config);
                                if (!projDefFile.getLinkedFile().isEmpty() || !projDefFile.getLinkedFolder().isEmpty()) {
                                    String msg = String.format(Messages.WARN_LINKED_RESOURCE, countSucc);
                                    int result = DialogUtil.openQuestionDialog((Shell)window.getShell(), (String)"Warning", (String)msg);
                                    if (result == 128) continue;
                                }
                                monitor.worked(1);
                                monitor.subTask(String.format(Messages.PROGRESS_STEP2, projName));
                                ToolFlagSetter flagSetter = new ToolFlagSetter(config, projDefFile.getSources());
                                flagSetter.setProjectDefinition(projDefFile);
                                flagSetter.setToolFlags(flagFile);
                                flagSetter.setEDCFlags(projDefFile);
                                monitor.worked(1);
                                monitor.subTask(String.format(Messages.PROGRESS_STEP2_1, projName));
                                ReferenceFlagSetter refSetter = new ReferenceFlagSetter(config);
                                refSetter.setReferenceFlags(projDefFile);
                                monitor.worked(1);
                                monitor.subTask(String.format(Messages.PROGRESS_STEP2_2, projName));
                                BuildStepSetter buildStepSetter = new BuildStepSetter(config);
                                buildStepSetter.setBuildStep(prepostFile);
                                monitor.worked(1);
                                monitor.subTask(String.format(Messages.PROGRESS_STEP2_3, projName));
                                ResourceFilterSetter resFilterSetter = new ResourceFilterSetter(project);
                                resFilterSetter.setPackageExcludeList(projDefFile);
                                monitor.worked(1);
                                monitor.subTask(String.format(Messages.PROGRESS_STEP3, projName));
                                String projDefFilePath = project.getLocation().append(ExportCLIProjectAction.PROJDEF_FILENAME).toOSString();
                                projDefFile.getWriter().write(projDefFilePath);
                                monitor.worked(1);
                                monitor.subTask(String.format(Messages.PROGRESS_STEP4, projName));
                                File buildDir = project.getFolder(ExportCLIProjectAction.BUILD_DIR).getLocation().toFile();
                                if (!buildDir.exists() && !buildDir.mkdirs()) {
                                    throw new InterruptedException(Messages.FAILED_TO_CREATE_BUILDDIR);
                                }
                                String toolFlagsFilePath = new Path(buildDir.getAbsolutePath()).append(ExportCLIProjectAction.TOOLFLAG_FILENAME).toOSString();
                                flagFile.getWriter().write(toolFlagsFilePath);
                                monitor.worked(1);
                                monitor.subTask(String.format(Messages.PROGRESS_STEP4_1, projName));
                                String buildDefFilePath = project.getLocation().append(ExportCLIProjectAction.BUILDDEF_FILENAME).toOSString();
                                prepostFile.getWriter().write(buildDefFilePath);
                                monitor.worked(1);
                                monitor.subTask(String.format(Messages.PROGRESS_STEP5, projName));
                                File templateDir = ExportCLIProjectAction.this.getMakefileTemplateDir(project, projDefFile.getAppProfile());
                                if (templateDir == null) {
                                    throw new InterruptedException(Messages.CANNOT_FIND_BUILDTEMPLATE);
                                }
                                if (!templateDir.exists() || !templateDir.isDirectory()) {
                                    throw new InterruptedException(String.format(Messages.NO_SUCH_DIRECTORY, templateDir.getAbsolutePath()));
                                }
                                if (!ExportCLIProjectAction.this.copyMakefiles(templateDir, buildDir.getAbsolutePath())) {
                                    throw new InterruptedException(String.format(Messages.FAILED_TO_COPY_MAKEFILE, templateDir.getAbsolutePath()));
                                }
                                monitor.worked(1);
                                ++countSucc;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new InterruptedException(String.valueOf(Messages.FAILED_TO_CONVERT) + " " + e.getMessage());
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            DialogUtil.openErrorDialog((Shell)window.getShell(), (String)Messages.FAILED_TO_CONVERT, (String)e.getMessage());
            return;
        }
        String convMsg = String.format(Messages.CONVERT_SUCCESS, countSucc);
        DialogUtil.openMessageDialog((Shell)window.getShell(), (String)convMsg);
    }

    private void setAppName(IProject project, ProjectDefFile projDef) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        String buildTargetName = info.getBuildArtifactName();
        projDef.setAppName(buildTargetName);
    }

    private boolean setAppType(IProject project, ProjectDefFile projDef) {
        TizenProjectType type = ProjectUtil.getTizenProjectType((IProject)project);
        if (type.isImeProject()) {
            projDef.setAppType(PROJECT_TYPE.sharedLib.toString());
        } else if (type.isNativeApplicationProject()) {
            projDef.setAppType(PROJECT_TYPE.app.toString());
        } else if (type.isNativeSharedLibraryProject()) {
            projDef.setAppType(PROJECT_TYPE.sharedLib.toString());
        } else if (type.isNativeStaticLibraryProject()) {
            projDef.setAppType(PROJECT_TYPE.staticLib.toString());
        } else {
            return false;
        }
        return true;
    }

    private boolean setAppProfile(IProject project, ProjectDefFile projDef) {
        TizenProjectDescription desc = ProjectUtil.getTizenProjectDescription((IProject)project);
        projDef.setAppProfile(desc.getPlatformName());
        return true;
    }

    private void setSourceList(IProject project, ProjectDefFile projDef, IConfiguration config) throws CoreException {
        this.srcEntries = config.getSourceEntries();
        if (this.srcEntries.length == 0) {
            this.srcEntries = new ICSourceEntry[]{new CSourceEntry((IPath)Path.EMPTY, null, 24)};
        } else {
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)config);
            this.srcEntries = CDataUtil.resolveEntries((ICSourceEntry[])this.srcEntries, (ICConfigurationDescription)cfgDes);
        }
        InternalResourceProxyVisitor resourceVisitor = new InternalResourceProxyVisitor(config);
        project.accept((IResourceProxyVisitor)resourceVisitor, 0);
        if (this.resources.isEmpty()) {
            return;
        }
        for (IResource res : this.resources) {
            IPath rcProjRelPath;
            if (res.getType() == 2) {
                if (!res.isLinked(512)) continue;
                projDef.addLinkedFolder(res.getLocation());
                continue;
            }
            if (res.getType() != 1 || !this.isSource(rcProjRelPath = res.getProjectRelativePath())) continue;
            if (res.isLinked(512)) {
                projDef.addLinkedFile(res.getLocation());
                this.saveResourceList(projDef, res.getLocation());
                continue;
            }
            this.saveResourceList(projDef, rcProjRelPath);
        }
    }

    private void saveAbsResourceList(ProjectDefFile projDef, IPath path) {
        projDef.addSourceFile(path);
        String ext = path.getFileExtension();
        if (ext.equals("po")) {
            projDef.addPoFile(path.toOSString());
        } else if (ext.equals("edc")) {
            projDef.addEdcFile(path.toOSString());
        }
    }

    private void saveResourceList(ProjectDefFile projDef, IPath path) {
        projDef.addSourceFile(path);
        String ext = path.getFileExtension();
        if (ext.equals("po")) {
            projDef.addPoFile(path.toOSString());
        } else if (ext.equals("edc")) {
            projDef.addEdcFile(path.toOSString());
        }
        CFileTypeAssociation[] assocs = this.getCFileTypeAssociations();
        Set<String> cExts = this.getAvailableExtensions(assocs, "org.eclipse.cdt.core.cSource");
        Set<String> cppExts = this.getAvailableExtensions(assocs, "org.eclipse.cdt.core.cxxSource");
        if (cExts.contains(ext)) {
            projDef.addCFile(path.toOSString());
        } else if (cppExts.contains(ext)) {
            projDef.addCppFile(path.toOSString());
        }
    }

    private Set<String> getAvailableExtensions(CFileTypeAssociation[] assocs, String contentType) {
        HashSet<String> extensions = new HashSet<String>();
        CFileTypeAssociation[] cFileTypeAssociationArray = assocs;
        int n = assocs.length;
        int n2 = 0;
        while (n2 < n) {
            CFileTypeAssociation assoc = cFileTypeAssociationArray[n2];
            IContentType type = assoc.getContentType();
            if (type.getId().equals(contentType)) {
                extensions.add(assoc.getSpec());
            }
            ++n2;
        }
        return extensions;
    }

    private CFileTypeAssociation[] getCFileTypeAssociations() {
        ArrayList<CFileTypeAssociation> list = new ArrayList<CFileTypeAssociation>();
        this.fillWithUserDefinedCFileTypeAssociations(list);
        this.fillWithPredefinedCFileTypeAssociations(list);
        CFileTypeAssociation[] assocs = new CFileTypeAssociation[list.size()];
        list.toArray(assocs);
        return assocs;
    }

    public IContentType[] getRegistedContentTypes() {
        String[] ids = CoreModel.getRegistedContentTypeIds();
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType[] ctypes = new IContentType[ids.length];
        int i = 0;
        while (i < ids.length) {
            ctypes[i] = manager.getContentType(ids[i]);
            ++i;
        }
        return ctypes;
    }

    private void fillWithUserDefinedCFileTypeAssociations(ArrayList<CFileTypeAssociation> list) {
        IContentType[] ctypes = this.getRegistedContentTypes();
        this.fillWithCFileTypeAssociations(ctypes, null, 9, list);
    }

    private void fillWithPredefinedCFileTypeAssociations(ArrayList<CFileTypeAssociation> list) {
        IContentType[] ctypes = this.getRegistedContentTypes();
        this.fillWithCFileTypeAssociations(ctypes, null, 10, list);
    }

    private void fillWithCFileTypeAssociations(IContentType[] ctypes, IScopeContext context, int type, ArrayList<CFileTypeAssociation> list) {
        IContentType[] iContentTypeArray = ctypes;
        int n = ctypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType ctype = iContentTypeArray[n2];
            try {
                String[] specs;
                IContentTypeSettings setting = ctype.getSettings(context);
                String[] stringArray = specs = setting.getFileSpecs(type);
                int n3 = specs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String spec = stringArray[n4];
                    CFileTypeAssociation assoc = new CFileTypeAssociation(spec, type, ctype);
                    list.add(assoc);
                    ++n4;
                }
            }
            catch (CoreException e) {
                this.logger.error("Failed to get file type associations", (Throwable)e);
            }
            ++n2;
        }
    }

    private boolean isSource(IPath path) {
        return !CDataUtil.isExcluded((IPath)path, (ICSourceEntry[])this.srcEntries);
    }

    private void addBuildResource(IProject project, IResource res) {
        if (res.getProject().equals((Object)project)) {
            this.resources.add(res);
        }
    }

    private File getMakefileTemplateDir(IProject project, String profile) {
        List infos = InstallPathConfig.getProfileInfos();
        TizenProjectDescription desc = ProjectUtil.getTizenProjectDescription((IProject)project);
        String profileName = desc.getProfileName();
        String profileVersion = desc.getVersion();
        for (ProfileInfo info : infos) {
            if (!info.getProfile().equals(profileName)) continue;
            String path = InstallPathConfig.getSamplesPath((ProfileInfo)info, (String)profileVersion);
            if (path == null) {
                return null;
            }
            File templateDir = new Path(path).append(MAKEFILE_DIR).toFile();
            return templateDir;
        }
        return null;
    }

    private boolean copyMakefiles(File srcDir, String destPath) {
        String[] files;
        String[] stringArray = files = srcDir.list();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            try {
                String from = new Path(srcDir.getAbsolutePath()).append(file).toOSString();
                IPath toPath = new Path(destPath).append(file);
                String to = toPath.toOSString();
                if (!file.equals(TOOLFLAG_FILENAME) || !toPath.toFile().exists()) {
                    FileUtil.copyTo((String)from, (String)to);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedProjects.clear();
        if (selection instanceof TreeSelection) {
            TreeSelection _selection = (TreeSelection)selection;
            Object[] objectArray = _selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IProject) {
                    this.selectedProjects.add((IProject)obj);
                }
                ++n2;
            }
        }
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow arg0) {
    }

    private String getDlgMsgIfNeedToOverwrite() {
        String msg = "";
        for (IProject project : this.selectedProjects) {
            File buildDir;
            File buildDefFile;
            File projDefFile = project.getLocation().append(PROJDEF_FILENAME).toFile();
            if (projDefFile.exists()) {
                msg = String.valueOf(msg) + String.format(" - %s/%s\n", project.getName(), PROJDEF_FILENAME);
            }
            if ((buildDefFile = project.getLocation().append(BUILDDEF_FILENAME).toFile()).exists()) {
                msg = String.valueOf(msg) + String.format(" - %s/%s\n", project.getName(), BUILDDEF_FILENAME);
            }
            if (!(buildDir = project.getFolder(BUILD_DIR).getLocation().toFile()).exists()) continue;
            msg = String.valueOf(msg) + String.format(" - %s/%s/*\n", project.getName(), BUILD_DIR);
        }
        if (msg.isEmpty()) {
            return null;
        }
        return String.valueOf(Messages.OVERWRITE_DLG_MSG) + msg;
    }

    private class InternalResourceProxyVisitor
    implements IResourceProxyVisitor {
        private IConfiguration config;
        private IProject project;

        public InternalResourceProxyVisitor(IConfiguration config) {
            this.config = config;
            this.project = (IProject)config.getOwner();
        }

        private boolean isGeneratedResource(IResource resource) {
            String[] configNames;
            IPath path = resource.getProjectRelativePath();
            String[] stringArray = configNames = ManagedBuildManager.getBuildInfo((IResource)this.project).getConfigurationNames();
            int n = configNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                Path root = new Path(name);
                if (root.isPrefixOf(path)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IResource resource = proxy.requestResource();
            boolean isSource = ExportCLIProjectAction.this.isSource(resource.getProjectRelativePath());
            if (proxy.getType() == 1) {
                IResourceInfo rcInfo = this.config.getResourceInfo(resource.getProjectRelativePath(), false);
                if (isSource) {
                    boolean willBuild = false;
                    if (rcInfo instanceof IFolderInfo) {
                        String ext = resource.getFileExtension();
                        if (((IFolderInfo)rcInfo).buildsFileType(ext) && !this.isGeneratedResource(resource)) {
                            willBuild = true;
                        }
                    } else {
                        willBuild = true;
                    }
                    if (willBuild) {
                        ExportCLIProjectAction.this.addBuildResource(this.project, resource);
                    }
                }
                return false;
            }
            if (proxy.getType() == 2) {
                if (!isSource || this.isGeneratedResource(resource)) {
                    return false;
                }
                ExportCLIProjectAction.this.addBuildResource(this.project, resource);
                return true;
            }
            return true;
        }
    }

    private static enum PROJECT_TYPE {
        app,
        sharedLib,
        staticLib;

    }
}

