/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build.makefile;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.ProjectUtil;

public class POBuildProvider
implements IManagedOutputNameProvider {
    private IProject project = null;
    private final String DIR_LOCALE = "locale";
    private final String DIR_LC_MESSAGES = "LC_MESSAGES";

    public IPath[] getOutputNames(ITool tool, IPath[] primaryInputNames) {
        if (primaryInputNames == null) {
            return null;
        }
        ArrayList<IPath> retPathList = new ArrayList<IPath>();
        IPath[] iPathArray = primaryInputNames;
        int n = primaryInputNames.length;
        int n2 = 0;
        while (n2 < n) {
            IPath inputName = iPathArray[n2];
            IPath targetFilePath = this.getTargetFilePath(tool, inputName);
            if (targetFilePath == null) {
                return null;
            }
            retPathList.add(targetFilePath);
            ++n2;
        }
        return retPathList.toArray(new IPath[retPathList.size()]);
    }

    private IPath getTargetFilePath(ITool tool, IPath inputName) {
        IPath targetFilePath;
        File parentDir;
        String[] splitedId;
        int length;
        if (inputName == null || inputName.segmentCount() <= 0) {
            return null;
        }
        String inExt = inputName.getFileExtension();
        String outExt = tool.getOutputExtension(inExt);
        String fileName = inputName.removeFileExtension().lastSegment();
        if (this.project == null) {
            return new Path(fileName).addFileExtension(outExt);
        }
        int projectSegmentCount = this.project.getLocation().segmentCount();
        String resDir = inputName.removeFirstSegments(projectSegmentCount).removeLastSegments(2).toOSString();
        String buildDir = ProjectUtil.getDefaultConfiguration((IProject)this.project).getName();
        String appId = ProjectUtil.getAppId((IProject)this.project);
        String outputFilename = ProjectUtil.getArtefactName((IProject)this.project);
        if (!StringUtil.isEmpty((CharSequence)appId) && (length = (splitedId = appId.split("\\.")).length) > 0) {
            outputFilename = splitedId[length - 1];
        }
        if (!(parentDir = (targetFilePath = this.project.getLocation().append(buildDir).append(resDir).append("locale").append(fileName).append("LC_MESSAGES").append(outputFilename).addFileExtension(outExt)).removeLastSegments(1).toFile()).exists() && !parentDir.mkdirs()) {
            return null;
        }
        return targetFilePath.makeRelativeTo(this.project.getLocation().append(buildDir));
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

