/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.tpklib.lib.PathUtil;

public class NativeCoreConfigurationManagerConstants {
    public static final Map<String, String> PACKAGING_DEFAULT_FILE_LIST = NativeCoreConfigurationManagerConstants.getDefaultPackagingFileList();
    public static final Map<String, String> PACKAGING_DEFAULT_BUILD_FILE_LIST = NativeCoreConfigurationManagerConstants.getDefaultPackagingBuildFileList();
    public static final Map<String, String> MULTI_PACKAING_DEFAULT_FILE_LIST = NativeCoreConfigurationManagerConstants.getDefaultMultiPackagingFileList();
    public static final List<String> PACKAGING_DEFAULT_EXCLUDE_LIST = NativeCoreConfigurationManagerConstants.getDefaultExcludeList();
    public static final List<String> PACKAGING_DEFAULT_EXCLUDE_EXTENSION_LIST = NativeCoreConfigurationManagerConstants.getDefaultExcludeExtensionList();
    public static final List<String> PACKAGING_DEFAULT_EXCLUDE_MAKE_FILE_LIST = NativeCoreConfigurationManagerConstants.getExcludeMakeFileExtensionList();
    public static final String MULTI_PACKAGING_DIR_NAME = ".packaging";

    private static Map<String, String> getDefaultPackagingFileList() {
        HashMap<String, String> fileList = new HashMap<String, String>();
        fileList.put("bin", "bin");
        fileList.put("lib", "lib");
        fileList.put("res", "res");
        fileList.put("shared", "shared");
        return fileList;
    }

    private static Map<String, String> getDefaultPackagingBuildFileList() {
        HashMap<String, String> fileList = new HashMap<String, String>();
        fileList.put("res", "res");
        fileList.put("shared", "shared");
        return fileList;
    }

    private static Map<String, String> getDefaultMultiPackagingFileList() {
        HashMap<String, String> fileList = new HashMap<String, String>();
        fileList.put(PathUtil.addPath((String[])new String[]{MULTI_PACKAGING_DIR_NAME, "tempres"}), "res");
        fileList.put(PathUtil.addPath((String[])new String[]{MULTI_PACKAGING_DIR_NAME, "tempbin"}), "bin");
        fileList.put(PathUtil.addPath((String[])new String[]{MULTI_PACKAGING_DIR_NAME, "templib"}), "lib");
        fileList.put(PathUtil.addPath((String[])new String[]{MULTI_PACKAGING_DIR_NAME, "tempshared"}), "shared");
        fileList.put("manifest_multi.xml", "tizen-manifest.xml");
        return fileList;
    }

    private static List<String> getDefaultExcludeList() {
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("data");
        excludeList.add(".manifest.tmp");
        excludeList.add(PathUtil.addPath((String[])new String[]{"res", "tep"}));
        return excludeList;
    }

    private static List<String> getDefaultExcludeExtensionList() {
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add(PathUtil.addPath((String[])new String[]{"res", "po", "*.po"}));
        excludeList.add(PathUtil.addPath((String[])new String[]{"shared", "res", "po", "*.po"}));
        excludeList.add(PathUtil.addPath((String[])new String[]{"res", "edje*", "*.edc"}));
        excludeList.add(PathUtil.addPath((String[])new String[]{"shared", "res", "edje*", "*.edc"}));
        return excludeList;
    }

    private static List<String> getExcludeMakeFileExtensionList() {
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add(".mk");
        excludeList.add(".ninja");
        return excludeList;
    }
}

