/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.cli;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.nativecore.cli.SetterUtil;
import org.tizen.nativecore.cli.model.ProjectDefFile;

public class ReferenceFlagSetter {
    private IProject project;
    private IConfiguration config;
    private static final String WHITESPACE = " ";
    private static final Logger logger = LoggerFactory.getLogger(ReferenceFlagSetter.class);

    public ReferenceFlagSetter(IConfiguration config) {
        this.config = config;
        this.project = (IProject)config.getOwner();
    }

    public void setReferenceFlags(ProjectDefFile projDef) {
        IConfigurationEnvironmentVariableSupplier envVariableSupplier = this.config.getEnvironmentVariableSupplier();
        if (envVariableSupplier == null) {
            return;
        }
        try {
            IProject[] projs = this.project.getReferencedProjects();
            ArrayList<IProject> projList = new ArrayList<IProject>();
            IProject[] iProjectArray = projs;
            int n = projs.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                if (ProjectUtil.isLibraryProject((IProject)proj)) {
                    projList.add(proj);
                }
                ++n2;
            }
            if (projList.isEmpty()) {
                return;
            }
            List linkOptions = NativeCoreConfigurationManager.makeLinkOptions(projList);
            List libOptions = NativeCoreConfigurationManager.makeLibraryOptions(projList);
            List includeOptions = NativeCoreConfigurationManager.makeIncludeOptions(projList);
            for (String op : linkOptions) {
                this.setRefLibraryPath(projDef, op);
            }
            for (String op : libOptions) {
                this.setRefLibraries(projDef, op);
            }
            for (String op : includeOptions) {
                this.setRefIncludePath(projDef, op);
            }
        }
        catch (CoreException coreException) {
            logger.error("Failed to get reference projects");
        }
    }

    public void setRefIncludePath(ProjectDefFile projDef, String value) {
        String[] sValues;
        if (value.isEmpty()) {
            return;
        }
        String[] stringArray = sValues = value.split(WHITESPACE);
        int n = sValues.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if ((val = val.trim()).startsWith("-I")) {
                String path = val.substring(2);
                if (!(path = SetterUtil.removeQuotes(path)).isEmpty()) {
                    if (new Path(path).isAbsolute()) {
                        if (!(path = SetterUtil.isUnderProjectPath(this.project, path) ? SetterUtil.encloseDoubleQuotes(SetterUtil.convertRelativePath(this.project, path)) : SetterUtil.encloseDoubleQuotes(SetterUtil.convertWorkspacePathToMacro(path))).isEmpty()) {
                            projDef.addRelativeCIncPath(path);
                            projDef.addRelativeCppIncPath(path);
                        }
                    } else {
                        projDef.addRelativeCIncPath(SetterUtil.encloseDoubleQuotes(path));
                        projDef.addRelativeCppIncPath(SetterUtil.encloseDoubleQuotes(path));
                    }
                }
            }
            ++n2;
        }
    }

    public void setRefLibraryPath(ProjectDefFile projDef, String value) {
        String[] sValues;
        if (value.isEmpty()) {
            return;
        }
        String[] stringArray = sValues = value.split(WHITESPACE);
        int n = sValues.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if ((val = val.trim()).startsWith("-L")) {
                String path = val.substring(2);
                if (!(path = SetterUtil.removeQuotes(path)).isEmpty()) {
                    if (new Path(path).isAbsolute()) {
                        if (!(path = SetterUtil.isUnderProjectPath(this.project, path) ? SetterUtil.encloseDoubleQuotes(SetterUtil.convertRelativePath(this.project, path)) : SetterUtil.encloseDoubleQuotes(SetterUtil.convertWorkspacePathToMacro(path))).isEmpty()) {
                            projDef.addRelativeLibPath(path);
                        }
                    } else {
                        projDef.addRelativeLibPath(SetterUtil.encloseDoubleQuotes(path));
                    }
                }
            }
            ++n2;
        }
    }

    public void setRefLibraries(ProjectDefFile projDef, String value) {
        String[] sValues;
        if (value.isEmpty()) {
            return;
        }
        String[] stringArray = sValues = value.split(WHITESPACE);
        int n = sValues.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if ((val = val.trim()).startsWith("-l")) {
                String lib = val.substring(2);
                if (lib.startsWith("\"") && lib.endsWith("\"")) {
                    lib = lib.substring(1, lib.length() - 1);
                }
                projDef.addUserLib(lib);
            }
            ++n2;
        }
    }
}

