/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.unittest;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.ui.wizards.ManagedBuildWizard;
import org.eclipse.cdt.ui.wizards.CNewWizard;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.cdt.ui.wizards.IWizardItemsListListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.wizards.TizenCommonWizard;
import org.tizen.nativecommon.unittest.IUnitTestHandler;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.nativecore.build.NativeCoreResourceManager;

public class CoreUnittestHandler
implements IUnitTestHandler {
    public static final String GTEST_TEMPLATE_DIRECTORY = "templates/Tests/CPPUnitTestTemplate/src/";
    public static final String GTEST_TEMPLATE_FILE = "CppUnitTest.cpp";
    protected static final Logger logger = LoggerFactory.getLogger(CoreUnittestHandler.class);

    public void setExternToHeader(String filePath, String targetProjectIncludeStr, ArrayList<IFile> addStringList) throws CoreException, IOException {
        File f = new File(filePath);
        StringBuilder strBuilder = new StringBuilder();
        RandomAccessFile raf = new RandomAccessFile(f, "rwd");
        try {
            byte[] tempRead = new byte[(int)raf.length()];
            raf.readFully(tempRead);
            raf.seek(0L);
            String fileRead = new String(tempRead);
            for (IFile file : addStringList) {
                String headerPath = file.getLocation().toString();
                if (!headerPath.startsWith(targetProjectIncludeStr)) continue;
                strBuilder.append(String.format("#include \"%s\"%n", headerPath.substring(targetProjectIncludeStr.length() + 1)));
            }
            strBuilder.append("\n");
            raf.write(strBuilder.toString().getBytes());
            raf.write(fileRead.getBytes());
        }
        finally {
            raf.close();
        }
    }

    public String getIncludeDirectory() {
        return "inc";
    }

    public String getProjectNamePattern() {
        return null;
    }

    public void createLibProjectFile(IProject testProject, IProgressMonitor monitor) throws CoreException, IOException {
    }

    public String getProjectSuffix() {
        return "Test";
    }

    public Image getTargetProjectIcon(IProject proj) {
        return null;
    }

    public EntryDescriptor getUnitTestProjectEntryDescriptor(Composite composite, IWizardItemsListListener wizardPage, TizenCommonWizard wizard) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui.CDTWizard");
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return null;
        }
        return this.createDescriptor(extensions, new Composite(composite, 0), wizardPage, (IWizard)wizard);
    }

    public String getProjectTypeId() {
        return "org.tizen.nativecore.target.sbi.gcc45.unittest";
    }

    public String getProjectTypeName() {
        return "Tizen Unit Test";
    }

    public String getDynamicAnalysisOption(IConfiguration config) {
        return NativeCoreConfigurationManager.getDynamicAnalysisOption(config);
    }

    public void setDynamicAnalysisOption(IConfiguration config, String option) {
        NativeCoreConfigurationManager.setDynamicAnalysisOption(config, option);
    }

    public void appendIncludePathToCCompiler(IConfiguration config, String includePath) {
        NativeCoreConfigurationManager.appendIncludePathToCCompiler(config, includePath);
    }

    public void appendIncludePathToCPPCompiler(IConfiguration config, String includePath) {
        NativeCoreConfigurationManager.appendIncludePathToCPPCompiler(config, includePath);
    }

    public void setIncludePathToCCompiler(IConfiguration config, String[] includePaths) {
        NativeCoreConfigurationManager.setIncludePathToCCompiler(config, includePaths);
    }

    public void setIncludePathToCPPCompiler(IConfiguration config, String[] includePaths) {
        NativeCoreConfigurationManager.setIncludePathToCPPCompiler(config, includePaths);
    }

    public String getCOptionIncludePathId() {
        return "gnu.c.compiler.option.include.paths";
    }

    public String getCPPOptionIncludePathId() {
        return "gnu.cpp.compiler.option.include.paths";
    }

    public void postProcess(IProject project) {
    }

    public ArrayList<IPath> getBuildObjectFiles(IProject project) {
        NativeCoreResourceManager targetProjectResource = new NativeCoreResourceManager(project);
        return targetProjectResource.getBuildObjectFiles();
    }

    public ArrayList<IResource> getBuildSources(IProject project) {
        NativeCoreResourceManager targetProjectResource = new NativeCoreResourceManager(project);
        return targetProjectResource.getBuildSources();
    }

    public String getSampleDirectory() {
        return "Template/NativeTest" + File.separator + "unittest";
    }

    public String getTemplateId() {
        return "org.tizen.nativecore.templates.NativeCoreUnitTestProject";
    }

    public String getTemplateParentID() {
        return "org.tizen.nativecore.buildArtefactType.app";
    }

    private EntryDescriptor createDescriptor(IExtension[] extensions, Composite right, IWizardItemsListListener ls, IWizard wizard) {
        EntryDescriptor parent = null;
        EntryDescriptor empty = null;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("wizard")) {
                    EntryDescriptor ed;
                    int n5;
                    int n6;
                    EntryDescriptor[] entryDescriptorArray;
                    CNewWizard w = null;
                    try {
                        w = (CNewWizard)element.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        return null;
                    }
                    if (w == null) {
                        return null;
                    }
                    if (w instanceof ManagedBuildWizard) {
                        w.setDependentControl(right, ls);
                        entryDescriptorArray = w.createItems(true, wizard);
                        n6 = entryDescriptorArray.length;
                        n5 = 0;
                        while (n5 < n6) {
                            ed = entryDescriptorArray[n5];
                            if (ed.getId().equals("org.tizen.nativecore.buildArtefactType.app")) {
                                parent = ed;
                                break;
                            }
                            ++n5;
                        }
                    } else {
                        entryDescriptorArray = w.createItems(true, wizard);
                        n6 = entryDescriptorArray.length;
                        n5 = 0;
                        while (n5 < n6) {
                            ed = entryDescriptorArray[n5];
                            if (ed.getId().equals("org.tizen.nativecore.target.sbi.gcc45.unittest")) {
                                empty = ed;
                                break;
                            }
                            ++n5;
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (parent == null || empty == null) {
            return null;
        }
        return null;
    }
}

