/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.command.CommandCancelException;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.file.EclipseCopyHandlingCommand;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.AbstractMultiPackager;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.nativecore.util.PackageUtil;
import org.tizen.tpklib.lib.PathUtil;

public class NativeIDEMultiPackager
extends AbstractMultiPackager {
    final String PO_EXTENSION = "po";
    final String EDC_EXTENSION = "edc";
    final String MO_EXTENSION = "mo";
    final String EDJ_EXTENSION = "edj";
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IProject rootPrj;
    private IProject[] refPrjs;
    private String rootPrjPath;
    private HashMap<String, IProject> refProejctMap = new HashMap();

    public NativeIDEMultiPackager(IProject rootPrj, IProgressMonitor monitor, Executor executor) {
        super(executor);
        this.rootPrj = rootPrj;
        IProject[] refPrjs = null;
        refPrjs = PackageUtil.getRefProjects(rootPrj);
        this.refPrjs = refPrjs;
        IProject[] iProjectArray = refPrjs;
        int n = refPrjs.length;
        int n2 = 0;
        while (n2 < n) {
            IProject refPrj = iProjectArray[n2];
            this.refProejctMap.put(refPrj.getLocation().toOSString(), refPrj);
            ++n2;
        }
        this.rootPrjPath = rootPrj.getLocation().toFile().getAbsolutePath();
    }

    protected String[] getRefPrjPaths() {
        Set<String> refPrjPaths = this.refProejctMap.keySet();
        return refPrjPaths.toArray(new String[refPrjPaths.size()]);
    }

    private IProject getRefProj(String path) {
        return this.refProejctMap.get(path);
    }

    protected String getRootPrjPath() {
        return this.rootPrjPath;
    }

    protected String getBinaryFolder() {
        return this.getBinaryFolder(null);
    }

    protected boolean validateMultiPackage() {
        TizenProjectType rootPrjType = ProjectUtil.getTizenProjectType((IProject)this.rootPrj);
        if (rootPrjType == null) {
            return false;
        }
        if (!rootPrjType.isCoreProject()) {
            return false;
        }
        return this.refPrjs != null && this.refPrjs.length > 0;
    }

    protected void buildPrjs() throws Exception {
        this.logger.debug("Do nothing");
    }

    protected IXMLStore getIXmlStore() throws Exception {
        return ProjectUtil.getXmlStore((IProject)this.rootPrj);
    }

    protected String getBinaryFolder(String prjPath) {
        if (StringUtil.isEmpty((CharSequence)prjPath)) {
            return ManagedBuildManager.getBuildInfo((IResource)this.rootPrj).getDefaultConfiguration().getName();
        }
        IProject refPrj = this.refProejctMap.get(prjPath);
        return ManagedBuildManager.getBuildInfo((IResource)refPrj).getDefaultConfiguration().getName();
    }

    protected IProject getRootProject() {
        return this.rootPrj;
    }

    protected void copyBinaries() throws IOException {
        String tempMultiPath = FileUtil.appendPath((String)this.getOutputPath(), (String)".packaging");
        IProject[] refPrjs = this.getRefProjects();
        if (refPrjs == null) {
            return;
        }
        File tempBinDir = new File(FileUtil.appendPath((String)tempMultiPath, (String)"tempbin"));
        tempBinDir.mkdirs();
        File tempLibDir = new File(FileUtil.appendPath((String)tempMultiPath, (String)"templib"));
        tempLibDir.mkdirs();
        IProject[] iProjectArray = refPrjs;
        int n = refPrjs.length;
        int n2 = 0;
        while (n2 < n) {
            File binaryFile;
            IProject project = iProjectArray[n2];
            IConfiguration config = ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration();
            String binaryName = ProjectUtil.getBinaryName((IProject)project);
            String binaryPath = String.valueOf(project.getLocation().toOSString()) + File.separatorChar + config.getName() + File.separatorChar + ProjectUtil.getBinaryName((IProject)project);
            String tempDirPath = tempBinDir.getCanonicalPath();
            TizenProjectType projType = ProjectUtil.getTizenProjectType((IProject)project);
            if (projType != null && ProjectUtil.isLibraryProject((IProject)project)) {
                tempDirPath = PathUtil.addPath((String[])new String[]{tempMultiPath, "temp" + NativeCoreConfigurationManager.getReferencedProjectPath((IProject)this.rootPrj, (String)project.getName())});
            }
            if (!FileUtil.isExist((String)tempDirPath)) {
                FileUtil.createDirectory((String)tempDirPath);
            }
            if (!(binaryFile = new File(binaryPath)).exists()) {
                String message = String.format("binary file '%s' does not exist", binaryPath);
                this.logger.error(message);
                throw new CommandCancelException(message);
            }
            Files.copy(binaryFile.toPath(), new File(tempDirPath, binaryName).toPath(), new CopyOption[0]);
            try {
                this.rootPrj.refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private void copyEdj(IProject project, String destRes, String srcRes, List<EclipseCopyHandlingCommand.CopyFile> copyFileList) {
        String format = FileUtil.appendPath((String)destRes, (String)"%s");
        List<String> edjFileList = this.getEdjFileList(project.findMember(srcRes));
        for (String edjFile : edjFileList) {
            String dest = edjFile.substring(srcRes.length(), edjFile.length());
            dest = String.format(format, dest);
            copyFileList.add(new EclipseCopyHandlingCommand.CopyFile(project, edjFile, dest));
        }
    }

    private void copyMo(IProject project, String destRes, String srcRes, List<EclipseCopyHandlingCommand.CopyFile> copyFileList) {
        String format = FileUtil.appendPath((String)destRes, (String)"%s");
        List<String> moFileList = this.getMoFileList(project.findMember(srcRes));
        for (String moFile : moFileList) {
            String dest = moFile.substring(srcRes.length(), moFile.length());
            dest = String.format(format, dest);
            copyFileList.add(new EclipseCopyHandlingCommand.CopyFile(project, moFile, dest));
        }
    }

    private List<String> getEdjFileList(IResource parent) {
        ArrayList<String> edjFileList = new ArrayList<String>();
        if (parent == null || !parent.exists()) {
            return edjFileList;
        }
        if (parent.getType() != 2) {
            return edjFileList;
        }
        IResource[] children = null;
        try {
            children = ((IFolder)parent).members();
        }
        catch (CoreException e) {
            this.logger.error("Failed to get children of " + parent, (Throwable)e);
            return edjFileList;
        }
        IResource[] iResourceArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            if (child.getType() == 2) {
                edjFileList.addAll(this.getEdjFileList(child));
            } else if ("edj".equals(FilenameUtil.getExtension((String)child.getName()))) {
                edjFileList.add(child.getProjectRelativePath().toOSString());
            }
            ++n2;
        }
        return edjFileList;
    }

    private List<String> getMoFileList(IResource parent) {
        ArrayList<String> moFileList = new ArrayList<String>();
        if (parent == null || !parent.exists()) {
            return moFileList;
        }
        if (parent.getType() != 2) {
            return moFileList;
        }
        IResource[] children = null;
        try {
            children = ((IFolder)parent).members();
        }
        catch (CoreException e) {
            this.logger.error("Failed to get children of " + parent, (Throwable)e);
            return moFileList;
        }
        IResource[] iResourceArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            if (child.getType() == 2) {
                moFileList.addAll(this.getMoFileList(child));
            } else if ("mo".equals(FilenameUtil.getExtension((String)child.getName()))) {
                moFileList.add(child.getProjectRelativePath().toOSString());
            }
            ++n2;
        }
        return moFileList;
    }

    protected void copyResResources(String source, String target, List<EclipseCopyHandlingCommand.CopyFile> copyFileList) {
        String targetTempPath = FileUtil.appendPath((String)this.getOutputPath(), (String)".packaging");
        String targetResPath = FileUtil.appendPath((String)targetTempPath, (String)target);
        IProject project = this.getRootProject();
        copyFileList.add(new EclipseCopyHandlingCommand.CopyFile(project, source, targetResPath));
        String buildConfFolder = ProjectUtil.getDefaultConfiguration((IProject)project).getName();
        String resFolder = FileUtil.appendPath((String)buildConfFolder, (String)source);
        this.copyEdj(project, targetResPath, resFolder, copyFileList);
        this.copyMo(project, targetResPath, resFolder, copyFileList);
    }

    protected void copyResResourcesFromRefPrj(String source, String target, List<EclipseCopyHandlingCommand.CopyFile> copyFileList) {
        String targetTempPath = FileUtil.appendPath((String)this.getOutputPath(), (String)".packaging");
        String targetResPath = FileUtil.appendPath((String)targetTempPath, (String)target);
        IProject[] iProjectArray = this.getRefProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject refProject = iProjectArray[n2];
            String refProjectPath = refProject.getLocation().toOSString();
            FileUtil.appendPath((String)refProjectPath, (String)source);
            copyFileList.add(new EclipseCopyHandlingCommand.CopyFile(refProject, source, targetResPath));
            String buildConfFolder = this.getBinaryFolder(refProjectPath);
            String resFolder = FileUtil.appendPath((String)buildConfFolder, (String)source);
            IProject project = this.getRefProj(refProjectPath);
            this.copyEdj(refProject, targetResPath, resFolder, copyFileList);
            this.copyMo(project, targetResPath, resFolder, copyFileList);
            ++n2;
        }
    }

    protected EclipseCopyHandlingCommand getCommand(List<EclipseCopyHandlingCommand.CopyFile> copyFileList) {
        return new EclipseCopyHandlingCommand(copyFileList){
            private List<File> poExcludeFileList;

            protected boolean isExcludedFile(IResource sourceFile, File targetFile) {
                String[] segments;
                return "po".equals(FilenameUtil.getExtension((String)sourceFile.getName())) ? (segments = sourceFile.getFullPath().segments())[0].equals("res") && segments[1].equals("po") : "edc".equals(FilenameUtil.getExtension((String)sourceFile.getName()));
            }
        };
    }

    public String getOutputPath() {
        if (this.outputPath != null) {
            return this.outputPath;
        }
        IConfiguration config = ManagedBuildManager.getBuildInfo((IResource)this.rootPrj).getDefaultConfiguration();
        if (config == null) {
            return this.getRootPrjPath();
        }
        return FileUtil.appendPath((String)this.getRootPrjPath(), (String)config.getName());
    }

    protected IProject[] getRefProjects() {
        return this.refPrjs;
    }
}

