/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.cli.model;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.tizen.nativecore.cli.model.FlagsFile;

public class FlagsFileWriter {
    private static final String DEF_DEBUG_FLAG = "DEBUG_OP";
    private static final String DEF_OPTIMIZE_FLAG = "OPTIMIZATION_OP";
    private static final String DEF_CPP_DEBUG_FLAG = "CPP_DEBUG_OP";
    private static final String DEF_CPP_OPTIMIZE_FLAG = "CPP_OPTIMIZATION_OP";
    private static final String DEF_COMP_FLAGS = "COMPILE_FLAGS";
    private static final String DEF_CPP_COMP_FLAGS = "CPP_COMPILE_FLAGS";
    private static final String DEF_LINK_FLAGS = "LINK_FLAGS";
    private static final String DEF_AR_FLAGS = "AR_FLAGS";
    private static final String DEF_EDC_FLAGS = "EDC_COMPILE_FLAGS";
    private static final String STRIP_INFO_OFF = "ifeq ($(STRIP_INFO),off)";
    private static final String STRIP_INFO_ON = "ifeq ($(STRIP_INFO),on)";
    private FlagsFile toolFlags;

    public FlagsFileWriter(FlagsFile toolFlags) {
        this.toolFlags = toolFlags;
    }

    public void write(String filePath) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(filePath));
        try {
            out.newLine();
            out.write(this.makeStatement(DEF_DEBUG_FLAG, this.toolFlags.getComplieDebugFlag()));
            out.newLine();
            out.write(this.makeStatement(DEF_CPP_DEBUG_FLAG, this.toolFlags.getCppComplieDebugFlag()));
            out.newLine();
            out.newLine();
            out.write(this.makeStatement(DEF_OPTIMIZE_FLAG, this.toolFlags.getComplieOptimizeFlag()));
            out.newLine();
            out.write(this.makeStatement(DEF_CPP_OPTIMIZE_FLAG, this.toolFlags.getCppComplieOptimizeFlag()));
            out.newLine();
            out.newLine();
            out.write(this.makeStatement(DEF_COMP_FLAGS, this.toolFlags.getCompileFlags()));
            out.newLine();
            out.newLine();
            out.write(this.makeStatement(DEF_CPP_COMP_FLAGS, this.toolFlags.getCppCompileFlags()));
            out.newLine();
            out.newLine();
            out.write(this.makeStatement(DEF_LINK_FLAGS, this.toolFlags.getLinkFlags()));
            out.newLine();
            out.newLine();
            out.write(STRIP_INFO_OFF);
            out.newLine();
            out.write(this.makeStatement(DEF_LINK_FLAGS, ""));
            out.newLine();
            out.write("else");
            out.newLine();
            out.write(STRIP_INFO_ON);
            out.newLine();
            out.write(this.makeStatement(DEF_LINK_FLAGS, "-s"));
            out.newLine();
            out.write("endif");
            out.newLine();
            out.write("endif");
            out.newLine();
            out.newLine();
            out.write(this.makeStatement(DEF_AR_FLAGS, this.toolFlags.getArFlags()));
            out.newLine();
            out.newLine();
            out.write(this.makeStatement(DEF_EDC_FLAGS, this.toolFlags.getEdcCompileFlags()));
        }
        finally {
            out.close();
        }
    }

    private String makeStatement(String key, String value) {
        return String.valueOf(key) + " = " + value;
    }
}

