/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.cli;

import java.nio.file.Paths;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.StringUtil;

public class SetterUtil {
    private static final String EMPTY_STRING = "";
    private static final String WHITESPACE = " ";

    public static String convertWorkspacePathToMacro(IProject project, String path) {
        java.nio.file.Path relProjectPath;
        String projectPath;
        java.nio.file.Path mainProjectPath;
        if (StringUtil.isEmpty((CharSequence)path)) {
            return EMPTY_STRING;
        }
        if (OSChecker.isWindows()) {
            path = path.replace("/", "\\");
        }
        return (path = (mainProjectPath = Paths.get(projectPath = project.getLocation().toOSString(), new String[0])).relativize(relProjectPath = Paths.get(path, new String[0])).toString()).isEmpty() ? EMPTY_STRING : path;
    }

    public static boolean isUnderProjectPath(IProject project, String path) {
        IPath projectPath = project.getLocation();
        Path targetPath = new Path(path);
        int i = 0;
        while (i < projectPath.segmentCount()) {
            String targetSeg;
            String projectSeg = projectPath.segment(i);
            if (!projectSeg.equals(targetSeg = targetPath.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String convertRelativePath(IProject project, String path) {
        String projectPath = project.getLocation().toOSString();
        if (path.startsWith(projectPath)) {
            if ((path = path.replace(projectPath, EMPTY_STRING)).isEmpty()) {
                return ".";
            }
            if (path.charAt(0) == '/' || path.charAt(0) == '\\') {
                path = path.substring(1);
            }
        }
        return path.isEmpty() ? EMPTY_STRING : path;
    }

    public static String encloseDoubleQuotes(String path) {
        if (!path.isEmpty() && path.contains(WHITESPACE)) {
            path = String.format("\"%s\"", path);
        }
        return path;
    }

    public static String removeQuotes(String path) {
        return path.replace("\"", EMPTY_STRING).replace("'", EMPTY_STRING);
    }
}

