/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Label;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Shortcut {
    public static final String ELEMENT = "shortcut";
    public static final String ATTR_APP_ID = "appid";
    public static final String ATTR_EXTRA_DATA = "extra_data";
    public static final String ATTR_EXTRA_KEY = "extra_key";
    private String appId;
    private String extraData;
    private String extraKey;
    private Label defaultLabel;
    private Icon defaultIcon;
    private List<LocaledValue> labelList = new ArrayList<LocaledValue>();

    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.setAppId(element.getAttribute(ATTR_APP_ID));
        this.setExtraData(element.getAttribute(ATTR_EXTRA_DATA));
        this.setExtraKey(element.getAttribute(ATTR_EXTRA_KEY));
        Node node = element.getFirstChild();
        while (node != null) {
            String nodeName = node.getNodeName();
            if (nodeName.equals("label")) {
                Label label = new Label();
                label.loadElement((Element)node);
                if (label.getLang() != null && label.getLang().length() > 0) {
                    this.labelList.add(new LocaledValue(label.getLang(), label.getValue()));
                } else {
                    this.defaultLabel = label;
                }
            } else if (nodeName.equals("icon")) {
                Icon icon = new Icon();
                icon.loadElement((Element)node);
                this.defaultIcon = icon;
            }
            node = node.getNextSibling();
        }
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        parent.appendChild(element);
        if (this.appId != null && this.appId.length() > 0) {
            element.setAttribute(ATTR_APP_ID, this.appId);
        }
        if (this.extraData != null && this.extraData.length() > 0) {
            element.setAttribute(ATTR_EXTRA_DATA, this.extraData);
        }
        if (this.extraKey != null && this.extraKey.length() > 0) {
            element.setAttribute(ATTR_EXTRA_KEY, this.extraKey);
        }
        this.generateIcons(dom, element);
        this.generateLabels(dom, element);
    }

    private void generateLabels(Document dom, Element parent) {
        List<LocaledValue> labels = this.getLabelList();
        if (labels.isEmpty() && this.defaultLabel == null) {
            return;
        }
        if (this.defaultLabel != null) {
            Element eLabel = dom.createElement("label");
            eLabel.setTextContent(this.defaultLabel.getValue());
            parent.appendChild(eLabel);
        }
        for (LocaledValue lv : labels) {
            Element eLabel = dom.createElement("label");
            if (lv.getLocale() != null && lv.getLocale().length() > 0) {
                eLabel.setAttribute("xml:lang", lv.getLocale());
            }
            eLabel.setTextContent(lv.getValue());
            parent.appendChild(eLabel);
        }
    }

    private void generateIcons(Document dom, Element parent) {
        if (this.defaultIcon == null) {
            return;
        }
        Element eIcon = dom.createElement("icon");
        eIcon.setTextContent(this.defaultIcon.getFileName());
        parent.appendChild(eIcon);
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public String getExtraKey() {
        return this.extraKey;
    }

    public void setExtraKey(String extraKey) {
        this.extraKey = extraKey;
    }

    public List<LocaledValue> getLabelList() {
        return this.labelList;
    }

    public void setLabelList(List<LocaledValue> labelList) {
        this.labelList = labelList;
    }

    public Label getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(Label defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(Icon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }
}

