/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.tizen.nativecore.ext.manifest.SupportSize;
import org.tizen.nativecore.misc.editor.CoreAdvancedPage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WidgetClass {
    public static final String ELEMENT = "widget-class";
    public static final String ATTR_CLASS_ID = "classid";
    public static final String ATTR_UPDATE_PERIOD = "update-period";
    public static final String ATTR_SETUP_APPID = "setup_appid";
    private Map<String, SupportSize> widgetClassSupportSizes = new HashMap<String, SupportSize>();
    private String classid;
    private String update_period;
    private String setup_appid;
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();

    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.classid = element.getAttribute(ATTR_CLASS_ID);
        this.update_period = element.getAttribute(ATTR_UPDATE_PERIOD);
        this.setup_appid = element.getAttribute(ATTR_SETUP_APPID);
        Node node = element.getFirstChild();
        while (node != null) {
            String nodeName = node.getNodeName();
            if (nodeName.equals("support-size")) {
                SupportSize supportSize = new SupportSize();
                supportSize.loadElement((Element)node);
                if (supportSize.getValue() != null) {
                    String[] stringArray = CoreAdvancedPage.SUPPORT_SIZES;
                    int n = CoreAdvancedPage.SUPPORT_SIZES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String size = stringArray[n2];
                        if (supportSize.getValue().equals(size)) {
                            this.widgetClassSupportSizes.put(supportSize.getValue(), supportSize);
                        }
                        ++n2;
                    }
                }
            }
            node = node.getNextSibling();
        }
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        if (this.classid != null && !this.classid.isEmpty()) {
            element.setAttribute(ATTR_CLASS_ID, this.classid);
        }
        if (this.update_period != null && !this.update_period.isEmpty()) {
            element.setAttribute(ATTR_UPDATE_PERIOD, this.update_period);
        }
        if (this.setup_appid != null && !this.setup_appid.isEmpty()) {
            element.setAttribute(ATTR_SETUP_APPID, this.setup_appid);
        }
        for (CustomAttribute customAttribute : this.getCustomAttrList()) {
            customAttribute.generateAttribute(element);
        }
        if (this.getWidgetClassSupportSizes().size() > 0) {
            Collection<SupportSize> collection = this.getWidgetClassSupportSizes().values();
            Iterator<SupportSize> Ir_values = collection.iterator();
            while (Ir_values.hasNext()) {
                Ir_values.next().generateElement(dom, element);
            }
        }
        for (CustomElement customElement : this.getCustomElementList()) {
            customElement.generateElement(dom, element);
        }
        parent.appendChild(element);
    }

    private boolean isCustomAttribute(String attr) {
        if (attr.equals(ATTR_CLASS_ID)) {
            return false;
        }
        if (attr.equals(ATTR_UPDATE_PERIOD)) {
            return false;
        }
        return !attr.equals(ATTR_SETUP_APPID);
    }

    public String getClassid() {
        return this.classid;
    }

    public String getUpdate_period() {
        return this.update_period;
    }

    public String getSetup_appid() {
        return this.setup_appid;
    }

    public Map<String, SupportSize> getWidgetClassSupportSizes() {
        if (this.widgetClassSupportSizes == null) {
            this.widgetClassSupportSizes = new HashMap<String, SupportSize>();
        }
        return this.widgetClassSupportSizes;
    }

    public void setWidgetClassSupportSizes(Map<String, SupportSize> widgetClassSupportSizes) {
        this.widgetClassSupportSizes = widgetClassSupportSizes;
    }

    public void setClassid(String classid) {
        this.classid = classid;
    }

    public void setUpdate_period(String update_period) {
        this.update_period = update_period;
    }

    public void setSetup_appid(String setup_appid) {
        this.setup_appid = setup_appid;
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }
}

