/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.csviewer;

import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.ViewUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecore.csviewer.view.CallStackView;
import org.tizen.sdblib.ICrashReportServiceListener;
import org.tizen.sdblib.IDevice;

public class CrashReportServiceListener
implements ICrashReportServiceListener {
    private static String CS_VIEW_ID = "org.tizen.nativecore.csviewer.view.CallStackView";
    private static Logger logger = LoggerFactory.getLogger(CrashReportServiceListener.class);

    public void fileCreated(IDevice device, String remoteCSPath) {
        logger.info("Detect a change file in CrashReport folder :" + remoteCSPath);
        if (device != null && remoteCSPath != null) {
            try {
                String strFilePath = ProjectUtil.pullCSFile((IDevice)device, (String)remoteCSPath);
                if (strFilePath != null) {
                    this.showView(CS_VIEW_ID, strFilePath);
                } else {
                    logger.error("Failed to pull CrashReport file from " + remoteCSPath);
                }
            }
            catch (Exception e) {
                logger.error("Failed to pull CrashReport file :", (Throwable)e);
            }
        }
    }

    private void showView(String viewId, String csPath) {
        ViewRunnable runnable = new ViewRunnable(viewId, csPath);
        SWTUtil.asyncExec((Runnable)runnable);
    }

    private static class ViewRunnable
    implements Runnable {
        String id;
        String csPath;

        public ViewRunnable(String id, String csPath) {
            this.id = id;
            this.csPath = csPath;
        }

        @Override
        public void run() {
            IWorkbenchWindow window = ViewUtil.getWorkbenchWindow();
            if (window == null) {
                return;
            }
            try {
                CallStackView viewPart = (CallStackView)window.getActivePage().showView(this.id);
                if (viewPart != null) {
                    viewPart.startCallStackView(this.csPath);
                } else {
                    logger.error("Cannot find cs view");
                }
            }
            catch (PartInitException e) {
                logger.error("Failed to show cs view :", (Throwable)e);
            }
        }
    }
}

