/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.imagecompressor.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativecore.imagecompressor.ImageCompressorTester;
import org.tizen.nativecore.imagecompressor.ImageCompressorTool;
import org.tizen.nativecore.imagecompressor.menu.Messages;

public class CompressorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IFile> imageFileList = this.getSelectedFiles(event);
        ArrayList<IFile> errorFileList = new ArrayList<IFile>();
        if (imageFileList.isEmpty()) {
            return null;
        }
        ImageCompressorTool tool = new ImageCompressorTool(imageFileList.get(0).getProject());
        String src = "";
        String dest = "";
        for (IFile imageFile : imageFileList) {
            src = imageFile.getLocation().toOSString();
            if (!tool.execute(src, dest = String.valueOf(FileUtil.getFileNameWithoutExtension((String)src)) + ".tgv")) {
                errorFileList.add(imageFile);
                continue;
            }
            try {
                imageFile.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        if (!errorFileList.isEmpty()) {
            SWTUtil.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    DialogUtil.openErrorDialog((String)Messages.CANNOT_EXECUTE_TOOL);
                }
            });
        }
        return null;
    }

    private List<IFile> getSelectedFiles(ExecutionEvent event) {
        ArrayList<IFile> imageFiles = new ArrayList<IFile>();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty()) {
            return imageFiles;
        }
        if (!(selection instanceof ITreeSelection)) {
            return imageFiles;
        }
        ITreeSelection treeSelection = (ITreeSelection)selection;
        for (Object item : treeSelection.toList()) {
            if (!(item instanceof IFile) || !ImageCompressorTester.isImageFile((IFile)item)) continue;
            imageFiles.add((IFile)item);
        }
        return imageFiles;
    }
}

