/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.tizen.nativecore.ext.manifest.Privilege;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AppControl {
    private List<AppControlItem> appServiceItems = new ArrayList<AppControlItem>();
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();
    private List<Privilege> privilegeList = new ArrayList<Privilege>();
    private List<String> operations = new ArrayList<String>();
    private List<String> uri = new ArrayList<String>();
    private List<String> mime = new ArrayList<String>();

    public List<AppControlItem> getAppServiceItems() {
        return this.appServiceItems;
    }

    public void addAppServiceItem(CATEGORIES category, String name) {
        AppControlItem item = new AppControlItem();
        item.setCategory(category);
        if (name != null) {
            item.setValue(name);
        } else {
            item.setValue("");
        }
        this.appServiceItems.add(item);
    }

    public void addAppServiceItems(AppControlItem appItem) {
        this.appServiceItems.add(appItem);
    }

    public List<String> getOperations() {
        return this.operations;
    }

    public void addOperation(String operation) {
        this.operations.add(operation);
    }

    public List<String> getUri() {
        return this.uri;
    }

    public void addUri(String uriS) {
        this.uri.add(uriS);
    }

    public List<String> getMime() {
        return this.mime;
    }

    public void addMime(String mimeStr) {
        this.mime.add(mimeStr);
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement("app-control");
        boolean writeNeeded = false;
        for (CustomAttribute customAttribute : this.getCustomAttrList()) {
            customAttribute.generateAttribute(element);
        }
        for (AppControlItem appControlItem : this.appServiceItems) {
            String appControlItemValue = appControlItem.getValue();
            if (appControlItemValue == null || appControlItemValue.length() <= 0) continue;
            Element eSub = dom.createElement(appControlItem.getCategory().toString());
            eSub.setAttribute("name", appControlItemValue);
            element.appendChild(eSub);
            writeNeeded = true;
        }
        if (writeNeeded) {
            parent.appendChild(element);
        }
        for (Privilege privilege : this.getPrivilegeList()) {
            privilege.generateElement(dom, element, privilege.getLevel());
        }
        for (CustomElement customElement : this.getCustomElementList()) {
            customElement.generateElement(dom, element);
        }
    }

    public void loadElement(Element element) {
        if (!element.getNodeName().equals("app-control")) {
            return;
        }
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            String attr = node.getNodeName();
            CustomAttribute custom = new CustomAttribute();
            custom.loadAttribute(attr, node.getNodeValue());
            this.getCustomAttrList().add(custom);
            ++i;
        }
        Node childNode = element.getFirstChild();
        while (childNode != null) {
            block13: {
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(CATEGORIES.mime.name()) || nodeName.equals(CATEGORIES.uri.name()) || nodeName.equals(CATEGORIES.operation.name())) {
                    CATEGORIES category = null;
                    try {
                        category = CATEGORIES.valueOf(nodeName);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        break block13;
                    }
                    AppControlItem item = new AppControlItem();
                    Element eChild = (Element)childNode;
                    item.setCategory(category);
                    item.setValue(eChild.getAttribute("name"));
                    this.addAppServiceItems(item);
                } else if (nodeName.equals("privilege")) {
                    Privilege privilege = new Privilege();
                    privilege.loadElement((Element)childNode);
                    this.getPrivilegeList().add(privilege);
                } else if (childNode.getNodeType() == 1) {
                    CustomElement custom = new CustomElement();
                    custom.loadElement((Element)childNode);
                    this.getCustomElementList().add(custom);
                }
            }
            childNode = childNode.getNextSibling();
        }
        this.operations.clear();
        this.uri.clear();
        this.mime.clear();
        for (AppControlItem item : this.appServiceItems) {
            if (item.getCategory() == CATEGORIES.operation) {
                this.operations.add(item.getValue());
            }
            if (item.getCategory() == CATEGORIES.uri) {
                this.uri.add(item.getValue());
            }
            if (item.getCategory() != CATEGORIES.mime) continue;
            this.mime.add(item.getValue());
        }
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }

    public List<Privilege> getPrivilegeList() {
        return this.privilegeList;
    }

    public class AppControlItem {
        private CATEGORIES category;
        private String value;

        public AppControlItem() {
        }

        public AppControlItem(CATEGORIES category, String value) {
            this.category = category;
            this.value = value;
        }

        public CATEGORIES getCategory() {
            return this.category;
        }

        public void setCategory(CATEGORIES category) {
            this.category = category;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static enum CATEGORIES {
        operation,
        uri,
        mime,
        subapp;

    }
}

