/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.console.MessageConsoleStream;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.nativecommon.build.PackageInfo;
import org.tizen.nativecommon.build.PackageListener;
import org.tizen.nativecore.build.Messages;
import org.tizen.nativecore.build.NativeCoreProjectDependentPackager;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.ext.xmlstore.CoreXMLStore;
import org.tizen.nativecore.misc.core.ManifestManager;

public class NativeCorePackageListener
implements PackageListener {
    public void installListener() {
        NativeCoreProjectDependentPackager.getInstance().addListener((PackageListener)this);
    }

    public void uninstallListener() {
        NativeCoreProjectDependentPackager.getInstance().removeListener((PackageListener)this);
    }

    public void preCreated(PackageInfo info) throws CoreException {
        if (info.isLaunchMode()) {
            return;
        }
        IProject project = info.getProject();
        ManifestManager.verifyExecutableName(project);
        CoreXMLStore manifest = new CoreXMLStore(project);
        if (manifest.loadXml()) {
            Manifest model = manifest.getCoreManifest();
            boolean hasScreenKey = false;
            for (String key : model.getFeature_map().keySet()) {
                if (!key.contains("screen.size")) continue;
                hasScreenKey = true;
                break;
            }
            if (!hasScreenKey) {
                ConsoleManager cm = info.getConsoleManager();
                if (cm == null) {
                    cm = new ConsoleManager(Messages.PACKAGE, false);
                    cm.clear();
                    cm.show();
                }
                MessageConsoleStream stderrStream = cm.getMessageConsoleStream(true);
                stderrStream.println("Since the screen size feature is not specified, the Tizen Store can reject the application.");
                stderrStream.println("In the features tab of the manifest editor, add at least 1 applicable screen size feature for the application.");
                stderrStream.println("For more information, please see 'http://developer.tizen.org/development/training/native-application/understanding-tizen-programming/application-filtering'");
            }
        }
    }
}

