/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.tizen.nativecore.ext.manifest.IPrivilege;
import org.tizen.nativecore.misc.core.PrivilegeLevel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Privilege
implements IPrivilege {
    private final String ELEMENT = "privilege";
    private final String ELEMENT_CONSUMER = "appdefined-privilege";
    private String value;
    private String description;
    private String licenseFile = new String("");
    private PrivilegeLevel level = PrivilegeLevel.PUBLIC;
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();

    public Privilege() {
    }

    public Privilege(String value) {
        this.value = value;
    }

    public Privilege(String value, PrivilegeLevel level, String desc) {
        this.value = value;
        this.level = level;
        this.description = desc;
    }

    public Privilege(String value, PrivilegeLevel level, String desc, String licenseFile) {
        this.value = value;
        this.level = level;
        this.description = desc;
        this.licenseFile = licenseFile;
    }

    public void setLevel(PrivilegeLevel level) {
        this.level = level;
    }

    @Override
    public PrivilegeLevel getLevel() {
        return this.level;
    }

    @Override
    public void loadElement(Element element) {
        if (!element.getNodeName().equals("privilege") && !element.getNodeName().equals("appdefined-privilege")) {
            return;
        }
        this.setValue(element.getTextContent());
        if (element.getNodeName().equals("appdefined-privilege")) {
            Node node;
            String attr;
            this.setDescription("[App-defined-consumer] " + element.getTextContent());
            NamedNodeMap attrs = element.getAttributes();
            if (attrs.getLength() > 0 && (attr = (node = attrs.item(0)).getNodeName()).equals("license")) {
                this.setLicenseFile(node.getNodeValue());
            }
        } else {
            NamedNodeMap attrs = element.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Node node = attrs.item(i);
                String attr = node.getNodeName();
                CustomAttribute custom = new CustomAttribute();
                custom.loadAttribute(attr, node.getNodeValue());
                this.getCustomAttrList().add(custom);
                ++i;
            }
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    CustomElement custom = new CustomElement();
                    custom.loadElement((Element)node);
                    this.getCustomElementList().add(custom);
                }
                node = node.getNextSibling();
            }
        }
    }

    @Override
    public void generateElement(Document dom, Element parent, PrivilegeLevel level) {
        Element element;
        if (level == PrivilegeLevel.APP_DEFINED_CONSUMER) {
            element = dom.createElement("appdefined-privilege");
            if (!this.licenseFile.isEmpty()) {
                element.setAttribute("license", this.licenseFile);
            }
        } else {
            element = dom.createElement("privilege");
        }
        parent.appendChild(element);
        if (this.getValue() != null && this.getValue().length() > 0) {
            element.setTextContent(this.getValue());
        }
        for (CustomAttribute customAttribute : this.getCustomAttrList()) {
            customAttribute.generateAttribute(element);
        }
        for (CustomElement customElement : this.getCustomElementList()) {
            customElement.generateElement(dom, element);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLicenseFile(String file) {
        this.licenseFile = file;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }

    public boolean equals(Object obj) {
        IPrivilege p = (IPrivilege)obj;
        return p.getValue().equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

