/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.ProjectUtil;
import org.tizen.nativecore.ext.manifest.Author;
import org.tizen.nativecore.ext.manifest.IApplication;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.misc.editor.CoreOverviewPage;
import org.tizen.nativecore.misc.editor.ManifestEditor;
import org.tizen.nativecore.misc.editor.SectionHelper;
import org.tizen.nativecore.misc.editor.UiAttrIcon;
import org.tizen.nativecore.misc.editor.UiAttrLocaledName;
import org.tizen.nativecore.misc.utils.Constants;

public class CoreProjectInfoSection {
    private CoreOverviewPage fPage;
    private UiAttrLocaledName fUiNames;
    private ManifestEditor fEditor;
    private UiAttrIcon fUiIcons;
    private Text fAppVersion;
    private Text fPackage;
    private Text fLabelText;
    private Combo apiVersion;
    private Text fExec;
    private Text fAppId;
    private Text author;
    private Text email;
    private Text website;
    private Text descriptions;
    private boolean isLabelUpdateFromXML;
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final String URL_PATTERN = "^http(s{0,1})://[a-zA-Z0-9_/\\-\\.]+\\.([A-Za-z/]{2,5})[a-zA-Z0-9_/\\&\\?\\=\\-\\.\\~\\%]*";
    private Pattern EmailPattern;
    private Pattern URLPattern;
    private Matcher matcher;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Author author;
            IMessageManager mgr;
            String[] digits;
            IMessageManager mgr2;
            String key;
            if (e.widget == CoreProjectInfoSection.this.fAppVersion) {
                CoreProjectInfoSection.this.fPage.setDirty(true);
                String ver = CoreProjectInfoSection.this.fAppVersion.getText().trim();
                key = "wrong application version";
                mgr2 = CoreProjectInfoSection.this.fPage.getManagedForm().getMessageManager();
                String msgError = "The version should be (x.y.z) format where 0<=x<=255, 0<=y<=255, 0<=z<=65535.";
                if (!ver.matches("^\\d+\\.\\d+\\.\\d+$")) {
                    mgr2.addMessage((Object)key, msgError, null, 3, (Control)CoreProjectInfoSection.this.fAppVersion);
                    ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidVersion = false;
                    return;
                }
                digits = ver.split("\\.");
                int x = Integer.parseInt(digits[0]);
                int y = Integer.parseInt(digits[1]);
                int z = Integer.parseInt(digits[2]);
                if (x > 255) {
                    mgr2.addMessage((Object)key, msgError, null, 3, (Control)CoreProjectInfoSection.this.fAppVersion);
                    ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidVersion = false;
                    return;
                }
                if (y > 255) {
                    mgr2.addMessage((Object)key, msgError, null, 3, (Control)CoreProjectInfoSection.this.fAppVersion);
                    ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidVersion = false;
                    return;
                }
                if (z > 65535) {
                    mgr2.addMessage((Object)key, msgError, null, 3, (Control)CoreProjectInfoSection.this.fAppVersion);
                    ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidVersion = false;
                    return;
                }
                ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidVersion = true;
                CoreProjectInfoSection.this.fPage.getManagedForm().getMessageManager().removeMessage((Object)key, (Control)CoreProjectInfoSection.this.fAppVersion);
                CoreProjectInfoSection.this.fEditor.getCoreManifest().setVersion(ver);
            }
            if (e.widget == CoreProjectInfoSection.this.author) {
                if (CoreProjectInfoSection.this.fEditor.getCoreManifest().getAuthor() == null) {
                    Author authorObj = new Author();
                    authorObj.setAuthor(CoreProjectInfoSection.this.author.getText().trim());
                    CoreProjectInfoSection.this.fEditor.getCoreManifest().setAuthor(authorObj);
                } else {
                    CoreProjectInfoSection.this.fEditor.getCoreManifest().getAuthor().setAuthor(CoreProjectInfoSection.this.author.getText().trim());
                }
                CoreProjectInfoSection.this.fPage.setDirty(true);
            }
            if (e.widget == CoreProjectInfoSection.this.email) {
                String emailText = CoreProjectInfoSection.this.email.getText().trim();
                CoreProjectInfoSection.this.matcher = CoreProjectInfoSection.this.EmailPattern.matcher(emailText);
                boolean isVaild = CoreProjectInfoSection.this.matcher.matches();
                String key2 = "Incorrect Email Address";
                mgr = CoreProjectInfoSection.this.fPage.getManagedForm().getMessageManager();
                if (!isVaild && !emailText.isEmpty()) {
                    mgr.addMessage((Object)key2, "Malformed Email", null, 2, (Control)CoreProjectInfoSection.this.email);
                } else {
                    mgr.removeMessage((Object)key2, (Control)CoreProjectInfoSection.this.email);
                }
                if (CoreProjectInfoSection.this.fEditor.getCoreManifest().getAuthor() == null) {
                    author = new Author();
                    author.setEmail(CoreProjectInfoSection.this.email.getText().trim());
                    CoreProjectInfoSection.this.fEditor.getCoreManifest().setAuthor(author);
                } else {
                    CoreProjectInfoSection.this.fEditor.getCoreManifest().getAuthor().setEmail(emailText);
                }
                CoreProjectInfoSection.this.fPage.setDirty(true);
            }
            if (e.widget == CoreProjectInfoSection.this.website) {
                String stringURL = CoreProjectInfoSection.this.website.getText().trim();
                String key3 = "Incorrect URL";
                CoreProjectInfoSection.this.matcher = CoreProjectInfoSection.this.URLPattern.matcher(stringURL);
                boolean isVaild = CoreProjectInfoSection.this.matcher.matches();
                mgr = CoreProjectInfoSection.this.fPage.getManagedForm().getMessageManager();
                if (!isVaild && !stringURL.isEmpty()) {
                    mgr.addMessage((Object)key3, "Malformed URL", null, 2, (Control)CoreProjectInfoSection.this.website);
                } else {
                    mgr.removeMessage((Object)key3, (Control)CoreProjectInfoSection.this.website);
                }
                if (CoreProjectInfoSection.this.fEditor.getCoreManifest().getAuthor() == null) {
                    author = new Author();
                    author.setWebsite(CoreProjectInfoSection.this.website.getText().trim());
                    CoreProjectInfoSection.this.fEditor.getCoreManifest().setAuthor(author);
                } else {
                    CoreProjectInfoSection.this.fEditor.getCoreManifest().getAuthor().setWebsite(stringURL);
                }
                CoreProjectInfoSection.this.fPage.setDirty(true);
            }
            if (e.widget == CoreProjectInfoSection.this.fPackage) {
                CoreProjectInfoSection.this.fPage.setDirty(true);
                String pckg = CoreProjectInfoSection.this.fPackage.getText().trim();
                key = "Mandatory field";
                mgr2 = CoreProjectInfoSection.this.fPage.getManagedForm().getMessageManager();
                String msgError = "Package is mandatory field.";
                if (pckg == null || pckg.length() == 0) {
                    mgr2.addMessage((Object)key, msgError, null, 3, (Control)CoreProjectInfoSection.this.fPackage);
                    ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidPackage = false;
                    return;
                }
                if (pckg.length() > Constants.MAX_PKGID_LENGTH || pckg.length() < Constants.MIN_PKGID_LENGTH) {
                    mgr2.addMessage((Object)key, Constants.pkgIDErrorMsg, null, 3, (Control)CoreProjectInfoSection.this.fPackage);
                    ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidPackage = false;
                    return;
                }
                ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidPackage = true;
                CoreProjectInfoSection.this.fPage.getManagedForm().getMessageManager().removeMessage((Object)key, (Control)CoreProjectInfoSection.this.fPackage);
                CoreProjectInfoSection.this.fEditor.getCoreManifest().setPackageId(pckg);
                return;
            }
            if (e.widget == CoreProjectInfoSection.this.fLabelText) {
                if (CoreProjectInfoSection.this.isLabelUpdateFromXML) {
                    return;
                }
                if (CoreProjectInfoSection.this.fEditor.getCoreManifest().getDefaultApp().getDefaultLabel() == null) {
                    org.tizen.nativecore.ext.manifest.Label label = new org.tizen.nativecore.ext.manifest.Label();
                    label.setValue(CoreProjectInfoSection.this.fLabelText.getText());
                    CoreProjectInfoSection.this.fEditor.getCoreManifest().getDefaultApp().setDefaultLabel(label);
                } else if (CoreProjectInfoSection.this.fLabelText.getText().isEmpty()) {
                    CoreProjectInfoSection.this.fEditor.getCoreManifest().getDefaultApp().setDefaultLabel(null);
                } else {
                    CoreProjectInfoSection.this.fEditor.getCoreManifest().getDefaultApp().getDefaultLabel().setValue(CoreProjectInfoSection.this.fLabelText.getText());
                }
                CoreProjectInfoSection.this.fPage.setDirty(true);
                return;
            }
            if (e.widget == CoreProjectInfoSection.this.descriptions) {
                CoreProjectInfoSection.this.fEditor.getCoreManifest().setDefaultDesc(CoreProjectInfoSection.this.descriptions.getText());
                CoreProjectInfoSection.this.fPage.setDirty(true);
                return;
            }
            if (e.widget == CoreProjectInfoSection.this.apiVersion) {
                CoreProjectInfoSection.this.fPage.setDirty(true);
                String apiVer = CoreProjectInfoSection.this.apiVersion.getText().trim();
                key = "wrong API version";
                mgr2 = CoreProjectInfoSection.this.fPage.getManagedForm().getMessageManager();
                String msgError = "The API version should be (w.x) or (w.x.y) or (w.x.y.z) format where 2<=w<=35, 3<=x<=35, 0<=y<=1295, 0<=z<=1295.";
                if (apiVer.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$") || apiVer.matches("^\\d+\\.\\d+\\.\\d+$") || apiVer.matches("^\\d+\\.\\d+$")) {
                    digits = apiVer.split("\\.");
                    int w = Integer.parseInt(digits[0]);
                    int x = Integer.parseInt(digits[1]);
                    int y = 0;
                    int z = 0;
                    if (digits.length > 2) {
                        y = Integer.parseInt(digits[2]);
                    }
                    if (digits.length > 3) {
                        z = Integer.parseInt(digits[3]);
                    }
                    if (w > 35 || w < 2) {
                        mgr2.addMessage((Object)key, msgError, null, 3, (Control)CoreProjectInfoSection.this.apiVersion);
                        ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidAPIVersion = false;
                        return;
                    }
                    if (x > 35 || x < 3 && w < 3) {
                        mgr2.addMessage((Object)key, msgError, null, 3, (Control)CoreProjectInfoSection.this.apiVersion);
                        ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidAPIVersion = false;
                        return;
                    }
                    if (y > 1295) {
                        mgr2.addMessage((Object)key, msgError, null, 3, (Control)CoreProjectInfoSection.this.apiVersion);
                        ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidAPIVersion = false;
                        return;
                    }
                    if (z > 1295) {
                        mgr2.addMessage((Object)key, msgError, null, 3, (Control)CoreProjectInfoSection.this.apiVersion);
                        ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidAPIVersion = false;
                        return;
                    }
                } else {
                    mgr2.addMessage((Object)key, msgError, null, 3, (Control)CoreProjectInfoSection.this.apiVersion);
                    ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidAPIVersion = false;
                    return;
                }
                ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidAPIVersion = true;
                CoreProjectInfoSection.this.fPage.getManagedForm().getMessageManager().removeMessage((Object)key, (Control)CoreProjectInfoSection.this.apiVersion);
                CoreProjectInfoSection.this.fEditor.getCoreManifest().setApiVersion(apiVer);
                CoreProjectInfoSection.this.fEditor.updatePages();
                return;
            }
            if (e.widget == CoreProjectInfoSection.this.fExec) {
                CoreProjectInfoSection.this.fPage.setDirty(true);
                String exec = CoreProjectInfoSection.this.fExec.getText().trim();
                key = "Mandatory field";
                mgr2 = CoreProjectInfoSection.this.fPage.getManagedForm().getMessageManager();
                String msgError = "Exec is mandatory field.";
                String msgLowercase = "Exec field can contain only lowercase characters.";
                if (exec == null || exec.length() == 0) {
                    mgr2.addMessage((Object)key, msgError, null, 3, (Control)CoreProjectInfoSection.this.fExec);
                    ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidExe = false;
                    return;
                }
                if (!exec.matches("[a-z0-9\\-_.]*")) {
                    mgr2.addMessage((Object)key, msgLowercase, null, 3, (Control)CoreProjectInfoSection.this.fExec);
                    ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidExe = false;
                    return;
                }
                ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidExe = true;
                CoreProjectInfoSection.this.fPage.getManagedForm().getMessageManager().removeMessage((Object)key, (Control)CoreProjectInfoSection.this.fExec);
                CoreProjectInfoSection.this.fEditor.getCoreManifest().getDefaultApp().setExec(CoreProjectInfoSection.this.fExec.getText());
                return;
            }
            if (e.widget == CoreProjectInfoSection.this.fAppId) {
                CoreProjectInfoSection.this.fPage.setDirty(true);
                String appId = CoreProjectInfoSection.this.fAppId.getText().trim();
                key = "Mandatory field";
                mgr2 = CoreProjectInfoSection.this.fPage.getManagedForm().getMessageManager();
                String msgError = "Application ID is mandatory field.";
                if (appId == null || appId.length() == 0) {
                    mgr2.addMessage((Object)key, msgError, null, 3, (Control)CoreProjectInfoSection.this.fAppId);
                    ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidAppId = false;
                    return;
                }
                if (appId.length() > Constants.MAX_APPID_LENGTH || appId.length() < Constants.MIN_APPID_LENGTH) {
                    mgr2.addMessage((Object)key, Constants.appIDErrorMsg, null, 3, (Control)CoreProjectInfoSection.this.fAppId);
                    ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidAppId = false;
                    return;
                }
                ((CoreProjectInfoSection)CoreProjectInfoSection.this).fPage.IsValidAppId = true;
                CoreProjectInfoSection.this.fPage.getManagedForm().getMessageManager().removeMessage((Object)key, (Control)CoreProjectInfoSection.this.fAppId);
                CoreProjectInfoSection.this.fEditor.getCoreManifest().getDefaultApp().setAppid(CoreProjectInfoSection.this.fAppId.getText());
                return;
            }
        }
    };

    public UiAttrLocaledName getfUiNames() {
        return this.fUiNames;
    }

    public void setfUiNames(UiAttrLocaledName fUiNames) {
        this.fUiNames = fUiNames;
    }

    private Font getBoldFont(Control label, int fontSize) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
        FontData[] fD = boldFont.getFontData();
        if (fontSize != 0) {
            fD[0].setHeight(fontSize);
        }
        return new Font(null, fD[0]);
    }

    private Font getNormalFont(Control label, int fontSize) {
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)label.getFont());
        Font boldFont = fontDescriptor.createFont((Device)label.getDisplay());
        FontData[] fD = boldFont.getFontData();
        if (fontSize != 0) {
            fD[0].setHeight(fontSize);
        }
        return new Font(null, fD[0]);
    }

    public Text createLabelAndText(Composite parent, String labelText, boolean isBold) {
        Composite grid = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        grid.setLayout((Layout)gridLayout);
        grid.setLayoutData((Object)new GridData(4, 0, true, false));
        grid.setBackground(new Color(null, 255, 255, 255));
        Label label = new Label(grid, 16384);
        GridData labelGD = new GridData(4, 0x1000000, true, false);
        labelGD.widthHint = 140;
        label.setText(labelText);
        if (isBold) {
            label.setFont(this.getBoldFont((Control)label, 10));
        } else {
            label.setFont(this.getNormalFont((Control)label, 10));
        }
        label.setForeground(new Color(null, 51, 51, 51));
        label.setBackground(new Color(null, 255, 255, 255));
        label.setLayoutData((Object)labelGD);
        GridData textGD = new GridData(4, 0, true, false);
        textGD.widthHint = 500;
        Text text = new Text(grid, 18432);
        text.setFont(this.getNormalFont((Control)text, 10));
        text.setLayoutData((Object)textGD);
        return text;
    }

    public void createLabel(Composite parent, String labelText) {
        Composite grid = new Composite(parent, 0);
        grid.setLayout((Layout)new GridLayout(2, false));
        grid.setLayoutData((Object)new GridData(4, 0, true, false));
        grid.setBackground(new Color(null, 255, 255, 255));
        Label label = new Label(grid, 16384);
        GridData labelGD = new GridData(4, 0x1000000, true, false);
        labelGD.widthHint = 140;
        label.setText(labelText);
        label.setFont(this.getBoldFont((Control)label, 10));
        label.setForeground(new Color(null, 51, 51, 51));
        label.setBackground(new Color(null, 255, 255, 255));
        label.setLayoutData((Object)labelGD);
    }

    public Combo CreateLableTextCombo(Composite parent, String comboLabelText, String[] comboText) {
        Composite gridCombo = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        gridCombo.setLayout((Layout)gridLayout);
        gridCombo.setLayoutData((Object)new GridData(1, 0, true, false));
        gridCombo.setBackground(new Color(null, 255, 255, 255));
        GridData labelGD = new GridData(4, 0x1000000, true, false);
        labelGD.widthHint = 140;
        Label label = new Label(gridCombo, 16384);
        label.setText(comboLabelText);
        label.setFont(this.getBoldFont((Control)label, 10));
        label.setForeground(new Color(null, 51, 51, 51));
        label.setBackground(new Color(null, 255, 255, 255));
        label.setLayoutData((Object)labelGD);
        GridData textGD = new GridData(4, 0, true, false);
        textGD.widthHint = 490;
        this.apiVersion = new Combo(gridCombo, 4);
        this.apiVersion.setItems(comboText);
        this.apiVersion.setLayoutData((Object)textGD);
        this.apiVersion.setBackground(new Color(null, 255, 255, 255));
        return this.apiVersion;
    }

    public CoreProjectInfoSection(FormToolkit tk, Composite ROOT, CoreOverviewPage page) {
        this.fPage = page;
        this.fEditor = page.getEditor();
        this.EmailPattern = Pattern.compile(EMAIL_PATTERN);
        this.URLPattern = Pattern.compile(URL_PATTERN);
        IProject project = null;
        IEditorInput input = this.fEditor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            project = file.getProject();
        }
        TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription(project);
        Set apiVersions = tizenDesc.getPlatformInfo().getVersions();
        this.fAppId = this.createLabelAndText(ROOT, "Application ID", true);
        this.fAppId.addModifyListener(this.modifyListener);
        this.fPackage = this.createLabelAndText(ROOT, "Package", true);
        this.fPackage.addModifyListener(this.modifyListener);
        this.fAppVersion = this.createLabelAndText(ROOT, "Version", true);
        this.fAppVersion.addModifyListener(this.modifyListener);
        this.apiVersion = this.CreateLableTextCombo(ROOT, "Api Version", apiVersions.toArray(new String[0]));
        this.apiVersion.addModifyListener(this.modifyListener);
        this.fLabelText = this.createLabelAndText(ROOT, "Label", true);
        this.fLabelText.addModifyListener(this.modifyListener);
        this.fExec = this.createLabelAndText(ROOT, "Exec", true);
        this.fExec.addModifyListener(this.modifyListener);
        this.createIconGroup(ROOT, tk, "Icon");
        this.createAuthorGroup(ROOT, tk, "Author");
        this.createDescGroup(ROOT, tk, "Description");
    }

    private void createAuthorGroup(Composite parent, FormToolkit tk, String name) {
        this.createLabel(parent, name);
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setBackground(new Color(null, 255, 255, 255));
        this.author = this.createLabelAndText((Composite)group, "Author", false);
        this.email = this.createLabelAndText((Composite)group, "Email", false);
        this.website = this.createLabelAndText((Composite)group, "Website", false);
        this.author.addModifyListener(this.modifyListener);
        this.email.addModifyListener(this.modifyListener);
        this.website.addModifyListener(this.modifyListener);
    }

    private void createDescGroup(Composite parent, FormToolkit tk, String name) {
        this.createLabel(parent, name);
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setBackground(new Color(null, 255, 255, 255));
        Composite table = SectionHelper.createGridLayout((Composite)group, tk, 2);
        table.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.descriptions = new Text(table, 2626);
        this.descriptions.setFont(this.getNormalFont((Control)this.descriptions, 10));
        this.descriptions.addModifyListener(this.modifyListener);
        GridData gd = new GridData(1808);
        gd.heightHint = 90;
        this.descriptions.setLayoutData((Object)gd);
    }

    private void createIconGroup(Composite parent, FormToolkit tk, String name) {
        this.createLabel(parent, "Icon");
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setBackground(new Color(null, 255, 255, 255));
        parent.setBackgroundMode(2);
        Composite table = SectionHelper.createGridLayout((Composite)group, tk, 2);
        table.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fUiIcons = new UiAttrIcon(this.fPage);
        this.fUiIcons.setLaunchIcon(true);
        this.fUiIcons.createUiOverview(table, tk, "Source", true);
    }

    public void update(Manifest model) {
        org.tizen.nativecore.ext.manifest.Label label;
        this.isLabelUpdateFromXML = true;
        IApplication app = this.fEditor.getCoreManifest().getDefaultApp();
        String value = model.getVersion();
        this.fAppVersion.setText(value);
        if (model.getAuthor() != null) {
            value = model.getAuthor().getAuthor();
            if (value != null && !value.isEmpty()) {
                this.author.setText(value);
            }
            if ((value = model.getAuthor().getEmail()) != null && !value.isEmpty()) {
                this.email.setText(value);
            }
            if ((value = model.getAuthor().getHref()) != null && !value.isEmpty()) {
                this.website.setText(value);
            }
        }
        if ((value = model.getPackageId()) != null && !value.isEmpty()) {
            this.fPackage.setText(value);
        }
        if ((label = app.getDefaultLabel()) != null) {
            if (label.getValue() != null) {
                this.fLabelText.setText(app.getDefaultLabel().getValue());
            }
        } else {
            this.fLabelText.setText("");
        }
        if ((value = model.getDefaultDesc()) != null && !value.isEmpty()) {
            this.descriptions.setText(model.getDefaultDesc());
        }
        Assert.isNotNull((Object)app);
        Icon icon = app.getDefaultIcon();
        this.fUiIcons.setInput(icon);
        this.fUiIcons.update();
        this.isLabelUpdateFromXML = false;
        value = model.getApiVersion();
        if (this.apiVersion != null) {
            if (value != null && !value.isEmpty()) {
                this.apiVersion.setText(model.getApiVersion());
            } else {
                this.apiVersion.select(0);
            }
        }
        value = app.getExec();
        this.fExec.setText(value);
        value = app.getAppid();
        this.fAppId.setText(value);
    }
}

