/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.tizen.nativecore.ext.manifest.BackgroundCategory;
import org.tizen.nativecore.misc.editor.CoreAdvancedPage;

public class IApplicationUtil {
    public static List<BackgroundCategory> getUnusedCategory(List<BackgroundCategory> bgCategoryList) {
        if (bgCategoryList == null || bgCategoryList.size() <= 0) {
            return CoreAdvancedPage.bgDefaultCategoryList;
        }
        ArrayList<BackgroundCategory> unsused = new ArrayList<BackgroundCategory>();
        for (BackgroundCategory b : CoreAdvancedPage.bgDefaultCategoryList) {
            if (IApplicationUtil.isAdded(b.getValue(), bgCategoryList)) continue;
            unsused.add(b);
        }
        return unsused;
    }

    private static boolean isAdded(String value, List<BackgroundCategory> bgCategoryList) {
        for (BackgroundCategory s : bgCategoryList) {
            if (!s.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValid(BackgroundCategory bgCategory) {
        if (bgCategory.getValue().isEmpty()) {
            return false;
        }
        String[] stringArray = CoreAdvancedPage.BG_CATEGORY_TYPES;
        int n = CoreAdvancedPage.BG_CATEGORY_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            if (bgCategory.getValue().equals(category)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int compareVersion(String ver1, String ver2) {
        int result = -1;
        String s1 = IApplicationUtil.updatedVersion(ver1, ".", 2);
        String s2 = IApplicationUtil.updatedVersion(ver2, ".", 2);
        result = s1.compareTo(s2);
        return result;
    }

    private static String updatedVersion(String version, String sep, int width) {
        String[] split = Pattern.compile(sep, 16).split(version);
        StringBuilder sb = new StringBuilder();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(String.format("%" + width + 's', s));
            ++n2;
        }
        return sb.toString();
    }
}

