/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tizen.nativecore.ext.manifest.AppControl;
import org.tizen.nativecore.ext.manifest.BackgroundCategory;
import org.tizen.nativecore.ext.manifest.Category;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.tizen.nativecore.ext.manifest.IApplication;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Image;
import org.tizen.nativecore.ext.manifest.Label;
import org.tizen.nativecore.ext.manifest.Metadata;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.utils.CheckerUtil;
import org.tizen.nativecore.misc.utils.Constants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WatchApplication
implements IApplication {
    public static final String ELEMENT = "watch-application";
    public static final String ATTR_APPID = "appid";
    public static final String ATTR_EXEC = "exec";
    public static final String ATTR_AMBIENT_SUPPORT = "ambient-support";
    public static final String ATTR_HW_ACCELERATION = "hw-acceleration";
    private String appid;
    private String exec;
    private String ambientSupport;
    private String hw_acceleration;
    private String apiVersion;
    private Label defaultLabel;
    private List<LocaledValue> label_list = new ArrayList<LocaledValue>();
    private List<LocaledValue> icon_list = new ArrayList<LocaledValue>();
    private Icon defaultIcon;
    private Image image;
    private List<Metadata> metadataList;
    public static final String STRING_TRUE = "true";
    public static final String STRING_FALSE = "false";
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();

    @Override
    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.setApiVersion(element.getAttribute("api-version"));
        this.setAppid(element.getAttribute(ATTR_APPID));
        this.setExec(element.getAttribute(ATTR_EXEC));
        if (element.getAttribute(ATTR_AMBIENT_SUPPORT).equals(STRING_TRUE)) {
            this.setAmbientSupport(STRING_TRUE);
        } else {
            this.setAmbientSupport(STRING_FALSE);
        }
        if (element.getAttribute(ATTR_HW_ACCELERATION).equals(Constants.HW_ACCELERATION_VALUES[1]) || element.getAttribute(ATTR_HW_ACCELERATION).equals(Constants.HW_ACCELERATION_VALUES[2])) {
            this.setHw_acceleration(element.getAttribute(ATTR_HW_ACCELERATION));
        } else {
            this.setHw_acceleration(Constants.HW_ACCELERATION_VALUES[0]);
        }
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            String attr = node.getNodeName();
            if (this.isCustomAttribute(attr)) {
                CustomAttribute custom = new CustomAttribute();
                custom.loadAttribute(attr, node.getNodeValue());
                this.getCustomAttrList().add(custom);
            }
            ++i;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            String nodeName = node.getNodeName();
            if (nodeName.equals("label")) {
                Label label = new Label();
                label.loadElement((Element)node);
                if (label.getLang() != null && label.getLang().length() > 0) {
                    this.label_list.add(new LocaledValue(label.getLang(), label.getValue()));
                } else {
                    this.defaultLabel = label;
                }
            } else if (nodeName.equals("icon")) {
                Icon icon = new Icon();
                icon.loadElement((Element)node);
                if (icon.getLang() != null && icon.getLang().length() > 0) {
                    this.icon_list.add(new LocaledValue(icon.getLang(), icon.getValue()));
                } else {
                    this.defaultIcon = icon;
                }
            } else if (nodeName.equals("metadata")) {
                Metadata metadata = new Metadata();
                metadata.loadElement((Element)node);
                this.getMetadataList().add(metadata);
            } else if (node.getNodeType() == 1) {
                CustomElement custom = new CustomElement();
                custom.loadElement((Element)node);
                this.getCustomElementList().add(custom);
            }
            node = node.getNextSibling();
        }
    }

    @Override
    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        parent.appendChild(element);
        if (this.apiVersion != null && CheckerUtil.isApplicationAPIVersionSupported(this.apiVersion)) {
            element.setAttribute("api-version", this.apiVersion);
        }
        if (this.getAppid() != null && this.getAppid().length() > 0) {
            element.setAttribute(ATTR_APPID, this.getAppid());
        } else {
            element.setAttribute(ATTR_APPID, "");
        }
        if (this.exec != null && this.exec.length() > 0) {
            element.setAttribute(ATTR_EXEC, this.exec);
        } else {
            element.setAttribute(ATTR_EXEC, "");
        }
        if (this.ambientSupport != null && this.ambientSupport.length() > 0) {
            element.setAttribute(ATTR_AMBIENT_SUPPORT, this.ambientSupport);
        } else {
            element.setAttribute(ATTR_AMBIENT_SUPPORT, STRING_FALSE);
        }
        if (this.hw_acceleration != null && this.hw_acceleration.length() > 0 && !this.hw_acceleration.equals(Constants.HW_ACCELERATION_VALUES[0])) {
            element.setAttribute(ATTR_HW_ACCELERATION, this.hw_acceleration);
        }
        for (CustomAttribute customAttribute : this.getCustomAttrList()) {
            customAttribute.generateAttribute(element);
        }
        this.generateLabels(dom, element);
        this.generateIcons(dom, element);
        if (this.image != null) {
            this.image.generateElement(dom, element);
        }
        for (Metadata metadata : this.getMetadataList()) {
            if (metadata == null) continue;
            metadata.generateElement(dom, element);
        }
        for (CustomElement customElement : this.getCustomElementList()) {
            customElement.generateElement(dom, element);
        }
    }

    @Override
    public String getExec() {
        return this.exec;
    }

    @Override
    public void setExec(String exec) {
        this.exec = exec;
    }

    @Override
    public String getAppid() {
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getAmbientSupport() {
        return this.ambientSupport;
    }

    public void setAmbientSupport(String ambientSupport) {
        this.ambientSupport = ambientSupport;
    }

    @Override
    public List<Metadata> getMetadataList() {
        if (this.metadataList == null) {
            this.metadataList = new ArrayList<Metadata>();
        }
        return this.metadataList;
    }

    @Override
    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    @Override
    public void setDefaultIcon(Icon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    @Override
    public Label getDefaultLabel() {
        return this.defaultLabel;
    }

    @Override
    public void setDefaultLabel(Label defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    @Override
    public List<LocaledValue> getLabels() {
        return this.label_list;
    }

    private void generateLabels(Document dom, Element parent) {
        List<LocaledValue> labels = this.getLabels();
        if (labels.isEmpty() && this.defaultLabel == null) {
            return;
        }
        if (this.defaultLabel != null) {
            Element eLabel = dom.createElement("label");
            eLabel.setTextContent(this.defaultLabel.getValue());
            parent.appendChild(eLabel);
        }
        for (LocaledValue lv : labels) {
            Element eLabel = dom.createElement("label");
            if (lv.getLocale() != null && lv.getLocale().length() > 0) {
                eLabel.setAttribute("xml:lang", lv.getLocale());
            }
            eLabel.setTextContent(lv.getValue());
            parent.appendChild(eLabel);
        }
    }

    @Override
    public List<LocaledValue> getIcons() {
        return this.icon_list;
    }

    private void generateIcons(Document dom, Element parent) {
        List<LocaledValue> icons = this.getIcons();
        if (icons.isEmpty() && this.defaultIcon == null) {
            return;
        }
        if (this.defaultIcon != null) {
            Element eIcon = dom.createElement("icon");
            eIcon.setTextContent(this.defaultIcon.getValue());
            parent.appendChild(eIcon);
        }
        for (LocaledValue lv : icons) {
            Element eIcon = dom.createElement("icon");
            if (lv.getLocale() != null && lv.getLocale().length() > 0) {
                eIcon.setAttribute("xml:lang", lv.getLocale());
            }
            eIcon.setTextContent(lv.getValue());
            parent.appendChild(eIcon);
        }
    }

    @Override
    public List<AppControl> getAppServiceList() {
        return null;
    }

    @Override
    public void setAppServiceList(List<AppControl> application_service) {
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public Map<String, Category> getCategory_map() {
        return null;
    }

    public String getHw_acceleration() {
        return this.hw_acceleration;
    }

    public void setHw_acceleration(String hw_acceleration) {
        this.hw_acceleration = hw_acceleration;
    }

    @Override
    public List<BackgroundCategory> getBgCategoryList() {
        return null;
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }

    private boolean isCustomAttribute(String attr) {
        if (attr.equals(ATTR_APPID)) {
            return false;
        }
        if (attr.equals(ATTR_EXEC)) {
            return false;
        }
        if (attr.equals(ATTR_HW_ACCELERATION)) {
            return false;
        }
        if (attr.equals(ATTR_AMBIENT_SUPPORT)) {
            return false;
        }
        return !attr.equals("api-version");
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }
}

