/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.tizen.nativecore.ext.manifest.Feature;
import org.tizen.nativecore.misc.editor.FeatureManager;
import org.tizen.nativecore.misc.editor.FeaturesPage;
import org.tizen.nativecore.misc.editor.Messages;
import org.tizen.nativecore.misc.editor.SectionHelper;

public abstract class FeatureBaseDetailsPage
implements IDetailsPage {
    protected IManagedForm fMForm;
    protected Feature fInput;
    protected Section fSection;
    protected FeaturesPage fPage;
    protected boolean isUpdateMethodCalled;
    protected FeatureManager fManager;

    public FeatureBaseDetailsPage(FeaturesPage page, FeatureManager featureManager) {
        this.fPage = page;
        this.fManager = featureManager;
    }

    public void initialize(IManagedForm mform) {
        this.fMForm = mform;
    }

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 2;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.fMForm.getToolkit();
        this.fSection = toolkit.createSection(parent, 256);
        this.fSection.setDescription(Messages.FeatureBaseDetailsPage_sdesc);
        toolkit.createCompositeSeparator((Composite)this.fSection);
        this.fSection.marginWidth = 10;
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        this.fSection.setLayoutData((Object)td);
        Composite client = SectionHelper.createTableLayout((Composite)this.fSection, toolkit, 2);
        this.createContent(toolkit, client);
        this.createSpacer(toolkit, client, 2);
        this.fSection.setClient((Control)client);
    }

    protected abstract void createContent(FormToolkit var1, Composite var2);

    protected void createSpacer(FormToolkit toolkit, Composite parent, int span) {
        Label spacer = toolkit.createLabel(parent, "");
        TableWrapData twd = new TableWrapData();
        twd.colspan = span;
        spacer.setLayoutData((Object)twd);
    }

    protected abstract void update();

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() == 1) {
            String key = (String)ssel.getFirstElement();
            this.fInput = this.fManager.getFeature(key);
        } else {
            this.fInput = null;
        }
        this.update();
    }

    public void commit(boolean onSave) {
    }

    public void setFocus() {
    }

    public void dispose() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.update();
    }

    public boolean setFormInput(Object input) {
        return false;
    }
}

