/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.editor.ISectionTableEvent;

public class UiSectionTable
implements SelectionListener,
ISelectionChangedListener,
IDoubleClickListener {
    private TableViewer fTable;
    private Button fAddBtn;
    private Button fRemoveBtn;
    private Button fEditBtn;
    private Composite tableComposite;
    ISectionTableEvent fEventHandler;

    private Font getBoldFont(Control label, int fontSize) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
        FontData[] fD = boldFont.getFontData();
        if (fontSize != 0) {
            fD[0].setHeight(fontSize);
        }
        return new Font(null, fD[0]);
    }

    public void createSection(FormToolkit toolkit, Composite parent, String sectionTitle, String desc, String[] columnNames, int[] columnWidth, ITableLabelProvider labelProvider) {
        Label textLabel = new Label(parent, 0);
        textLabel.setFont(this.getBoldFont((Control)textLabel, 10));
        textLabel.setText(sectionTitle);
        textLabel.setBackground(new Color(null, 255, 255, 255));
        textLabel.setForeground(new Color(null, 0, 138, 238));
        new GridData();
        Label desLabel = new Label(parent, 16384);
        desLabel.setText(desc);
        desLabel.setBackground(new Color(null, 255, 255, 255));
        desLabel.setForeground(new Color(null, 51, 51, 51));
        desLabel.setFont(this.getBoldFont((Control)desLabel, 10));
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalAlignment = 3;
        buttonGridData.grabExcessHorizontalSpace = true;
        Composite buttonsComposite = toolkit.createComposite(parent);
        buttonsComposite.setLayout((Layout)new GridLayout(3, false));
        buttonsComposite.setLayoutData((Object)buttonGridData);
        this.fAddBtn = new Button(buttonsComposite, 0x2000000);
        String fBtnAddEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_add_over.png").getFile();
        this.fAddBtn.setBackgroundImage(new Image(null, new ImageData(fBtnAddEnabled)));
        this.fAddBtn.addSelectionListener((SelectionListener)this);
        this.fEditBtn = new Button(buttonsComposite, 0x2000000);
        String fBtnEditEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_edit_over.png").getFile();
        this.fEditBtn.setBackgroundImage(new Image(null, new ImageData(fBtnEditEnabled)));
        this.fEditBtn.addSelectionListener((SelectionListener)this);
        this.fEditBtn.setEnabled(false);
        this.fRemoveBtn = new Button(buttonsComposite, 0x2000000);
        String fBtnRemoveEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_delete_over.png").getFile();
        this.fRemoveBtn.setBackgroundImage(new Image(null, new ImageData(fBtnRemoveEnabled)));
        this.fRemoveBtn.addSelectionListener((SelectionListener)this);
        this.fRemoveBtn.setEnabled(false);
        Composite tableGridComposite = toolkit.createComposite(parent);
        GridLayout gl = new GridLayout(columnNames.length, false);
        gl.marginWidth = 0;
        tableGridComposite.setLayout((Layout)gl);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.widthHint = 600;
        tableGridComposite.setLayoutData((Object)gridData);
        toolkit.paintBordersFor(tableGridComposite);
        this.tableComposite = tableGridComposite;
        Composite tableComposite = new Composite(tableGridComposite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout layout = new TableColumnLayout();
        tableComposite.setLayout((Layout)layout);
        this.fTable = new TableViewer(tableComposite, 68352);
        Table table = this.fTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        int i = 0;
        while (i < columnNames.length) {
            TableViewerColumn col = new TableViewerColumn(this.fTable, 0);
            layout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnPixelData(columnWidth[i], true, true));
            col.getColumn().setText(columnNames[i]);
            ++i;
        }
        if (labelProvider != null) {
            this.fTable.setLabelProvider((IBaseLabelProvider)labelProvider);
        }
        this.fTable.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fTable.addDoubleClickListener((IDoubleClickListener)this);
    }

    public TableViewer getTable() {
        return this.fTable;
    }

    public Composite getTableComposite() {
        return this.tableComposite;
    }

    public void setEventHandler(ISectionTableEvent fEvent) {
        this.fEventHandler = fEvent;
    }

    public void setEnabled(boolean enable) {
        this.fAddBtn.setEnabled(enable);
        this.fEditBtn.setEnabled(enable);
        this.fRemoveBtn.setEnabled(enable);
        if (enable) {
            if (this.fTable.getSelection().isEmpty()) {
                this.fEditBtn.setEnabled(false);
                this.fRemoveBtn.setEnabled(false);
            } else {
                this.fEditBtn.setEnabled(true);
                this.fRemoveBtn.setEnabled(true);
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.fAddBtn) {
            this.fEventHandler.onAdd();
        }
        if (e.widget == this.fRemoveBtn) {
            this.fEventHandler.onRemove();
        }
        if (e.widget == this.fEditBtn) {
            this.fEventHandler.onEdit();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            this.fRemoveBtn.setEnabled(false);
            this.fEditBtn.setEnabled(false);
        } else {
            this.fRemoveBtn.setEnabled(true);
            this.fEditBtn.setEnabled(true);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.fEventHandler != null) {
            this.fEventHandler.onEdit();
        }
    }

    public void setEditNotVisible() {
        if (this.fEditBtn != null) {
            this.fEditBtn.setVisible(false);
        }
    }
}

