/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.tizen.nativecore.ext.manifest.SupportSize;
import org.tizen.nativecore.ext.manifest.WidgetClass;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.tizen.nativecore.misc.editor.UiAttrIcon;
import org.tizen.nativecore.misc.editor.dlg.UiNewWidgetClassDialog;

public class UiWidgetClassAttrIconWithCheck
extends UiAttrIcon {
    private Button fCheck;
    private SupportSize fRefSize;
    private WidgetClass currentWidgetClass;
    private UiNewWidgetClassDialog dialog;
    private String labelText;
    private boolean updateUIFlag;

    public UiWidgetClassAttrIconWithCheck(TizenFormPage page, WidgetClass editTarget, UiNewWidgetClassDialog dialog) {
        super(page);
        this.currentWidgetClass = editTarget;
        this.dialog = dialog;
    }

    @Override
    public void createUi(Composite parent, FormToolkit toolkit, final String labelText, boolean preview) {
        this.labelText = labelText;
        this.fCheck = toolkit.createButton(parent, labelText, 32);
        this.fCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (UiWidgetClassAttrIconWithCheck.this.fCheck.getSelection()) {
                    UiWidgetClassAttrIconWithCheck.this.setEnableIconUi(true);
                    if (UiWidgetClassAttrIconWithCheck.this.fRefSize == null) {
                        UiWidgetClassAttrIconWithCheck.this.fRefSize = new SupportSize();
                        UiWidgetClassAttrIconWithCheck.this.fRefSize.setValue(labelText);
                        UiWidgetClassAttrIconWithCheck.this.setInput(UiWidgetClassAttrIconWithCheck.this.fRefSize.getPreview());
                    }
                    UiWidgetClassAttrIconWithCheck.this.getCurrentWidgetClass().getWidgetClassSupportSizes().put(labelText, UiWidgetClassAttrIconWithCheck.this.fRefSize);
                } else {
                    UiWidgetClassAttrIconWithCheck.this.setEnableIconUi(false);
                    if (UiWidgetClassAttrIconWithCheck.this.fRefSize != null) {
                        UiWidgetClassAttrIconWithCheck.this.getCurrentWidgetClass().getWidgetClassSupportSizes().remove(labelText);
                        UiWidgetClassAttrIconWithCheck.this.fRefSize = null;
                    }
                }
                UiWidgetClassAttrIconWithCheck.this.dialog.validate();
            }
        });
        this.createIconUi(parent, toolkit);
        this.updateUIFlag = true;
        this.setEnableIconUi(false);
    }

    @Override
    protected void onBrowse() {
        super.onBrowse();
        this.getPage().setDirty(false);
    }

    private void setEnableIconUi(boolean enable) {
        if (!enable) {
            this.getTextWidget().setText("");
        }
        this.getTextWidget().setEnabled(enable);
        this.getButtonWidget().setEnabled(enable);
    }

    @Override
    protected void onTextModified() {
        if (this.updateUIFlag) {
            this.updateUIFlag = false;
            return;
        }
        SupportSize size = this.getCurrentWidgetClass().getWidgetClassSupportSizes().get(this.labelText);
        if (size != null) {
            size.setPreview(this.getTextWidget().getText());
            this.validate();
        }
    }

    public void updateUI(SupportSize supportSize) {
        if (supportSize != null) {
            this.fCheck.setSelection(true);
            this.fRefSize = supportSize;
            this.setInput(this.fRefSize.getPreview());
            this.setEnableIconUi(true);
        } else {
            this.fCheck.setSelection(false);
            this.setEnableIconUi(false);
        }
    }

    public String getLabelText() {
        return this.labelText;
    }

    public SupportSize getSupportSize() {
        return this.fRefSize;
    }

    public WidgetClass getCurrentWidgetClass() {
        return this.currentWidgetClass;
    }
}

