/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.TizenSplashScreen;
import org.tizen.nativecore.misc.editor.SectionHelper;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.tizen.nativecore.misc.editor.UiAttrIcon;
import org.tizen.nativecore.misc.utils.Constants;

public class UiNewSplashScreenDialog
extends SelectionStatusDialog {
    private TizenSplashScreen fSplashScreen;
    private FormToolkit toolkit;
    private TizenFormPage fpage;
    private Combo fType;
    private Combo fResolution;
    private Combo fOrientation;
    private Combo fIndicatorDisplay;
    private Text fOperation;
    private Composite parentComposite;
    private UiAttrImage fResource;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (UiNewSplashScreenDialog.this.fSplashScreen == null) {
                UiNewSplashScreenDialog.this.fSplashScreen = new TizenSplashScreen();
            }
            if (e.widget == UiNewSplashScreenDialog.this.fType) {
                UiNewSplashScreenDialog.this.fSplashScreen.setType(UiNewSplashScreenDialog.this.fType.getText());
            } else if (e.widget == UiNewSplashScreenDialog.this.fOrientation) {
                UiNewSplashScreenDialog.this.fSplashScreen.setOrientation(UiNewSplashScreenDialog.this.fOrientation.getText());
            } else if (e.widget == UiNewSplashScreenDialog.this.fResolution) {
                UiNewSplashScreenDialog.this.fSplashScreen.setDpi(UiNewSplashScreenDialog.this.fResolution.getText());
            } else if (e.widget == UiNewSplashScreenDialog.this.fIndicatorDisplay) {
                if (UiNewSplashScreenDialog.this.fIndicatorDisplay.getText().equalsIgnoreCase("true")) {
                    UiNewSplashScreenDialog.this.fSplashScreen.setIndicator(true);
                } else if (UiNewSplashScreenDialog.this.fIndicatorDisplay.getText().equalsIgnoreCase("false")) {
                    UiNewSplashScreenDialog.this.fSplashScreen.setIndicator(false);
                }
            } else if (e.widget == UiNewSplashScreenDialog.this.fResource.getTextWidget()) {
                UiNewSplashScreenDialog.this.fResource.validate();
            } else if (e.widget == UiNewSplashScreenDialog.this.fOperation) {
                UiNewSplashScreenDialog.this.fSplashScreen.setOperation(UiNewSplashScreenDialog.this.fOperation.getText());
            }
            if (UiNewSplashScreenDialog.this.getButton(0) != null) {
                if (UiNewSplashScreenDialog.this.fResource.validate() && UiNewSplashScreenDialog.this.fSplashScreen.getType() != null && UiNewSplashScreenDialog.this.fSplashScreen.getOrientation() != null) {
                    UiNewSplashScreenDialog.this.getButton(0).setEnabled(true);
                } else {
                    UiNewSplashScreenDialog.this.getButton(0).setEnabled(false);
                }
            }
        }
    };

    public UiNewSplashScreenDialog(FormToolkit tk, TizenFormPage page) {
        super(Display.getDefault().getActiveShell());
        this.setTitle("Attributes for Splash Screen");
        this.toolkit = tk;
        this.fpage = page;
    }

    protected void computeResult() {
        if (this.fSplashScreen != null) {
            this.fSplashScreen.setSrc(this.fResource.getIconInput());
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.parentComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 20;
        layout.marginBottom = 9;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        this.parentComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 510;
        this.parentComposite.setLayoutData((Object)gd);
        Composite table = SectionHelper.createTableLayout(this.parentComposite, this.toolkit, 2);
        this.fType = SectionHelper.createLabelAndReadOnlyCombo(table, this.toolkit, "Resource Type", new String[]{"img", "edj"}, "Splash-Screen Resource Type");
        this.fType.addModifyListener(this.modifyListener);
        this.fResolution = SectionHelper.createLabelAndReadOnlyCombo(table, this.toolkit, "Resolution", Constants.RESOLUTION_VALUES, "Splash-Screen Resource Resolution");
        this.fResolution.addModifyListener(this.modifyListener);
        this.fOrientation = SectionHelper.createLabelAndReadOnlyCombo(table, this.toolkit, "Orientation", Constants.ORIENTTION_VALUES, "Splash-Screen Resource Orientation");
        this.fOrientation.addModifyListener(this.modifyListener);
        this.fIndicatorDisplay = SectionHelper.createLabelAndReadOnlyCombo(table, this.toolkit, "Indicator Display", Constants.BOOLEAN_VALUES, "Splash-Screen Indicator Display");
        this.fIndicatorDisplay.select(0);
        this.fIndicatorDisplay.addModifyListener(this.modifyListener);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        Group group = new Group(table, 4);
        group.setText("Resource");
        group.setLayout((Layout)new GridLayout());
        group.setBackground(new Color(null, 255, 255, 255));
        TableWrapData twd = new TableWrapData(256, 16);
        twd.colspan = 2;
        group.setLayoutData((Object)twd);
        parent.setBackgroundMode(2);
        Composite resource = SectionHelper.createGridLayout((Composite)group, this.toolkit, 2);
        resource.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fResource = new UiAttrImage(this.fpage, true);
        this.fResource.createUi(resource, this.toolkit, "Source", false);
        this.fResource.addModifyListener(this.modifyListener);
        this.fOperation = SectionHelper.createLabelAndText(table, this.toolkit, "App-control Operation", "Splash-Screen Specific App-control Operation", "");
        this.fOperation.addModifyListener(this.modifyListener);
        this.initialize();
        return this.parentComposite;
    }

    private void initialize() {
        if (this.fSplashScreen != null) {
            if (this.fSplashScreen.getIndicator()) {
                this.fIndicatorDisplay.select(0);
            } else {
                this.fIndicatorDisplay.select(1);
            }
            if (this.fSplashScreen.getType().equalsIgnoreCase("img")) {
                this.fType.select(0);
            } else if (this.fSplashScreen.getType().equalsIgnoreCase("edj")) {
                this.fType.select(1);
            }
            if (this.fSplashScreen.getDpi().equalsIgnoreCase("ldpi")) {
                this.fResolution.select(0);
            } else if (this.fSplashScreen.getDpi().equalsIgnoreCase("mdpi")) {
                this.fResolution.select(1);
            } else if (this.fSplashScreen.getDpi().equalsIgnoreCase("hdpi")) {
                this.fResolution.select(2);
            } else if (this.fSplashScreen.getDpi().equalsIgnoreCase("xhdpi")) {
                this.fResolution.select(3);
            } else if (this.fSplashScreen.getDpi().equalsIgnoreCase("xxhdpi")) {
                this.fResolution.select(4);
            }
            if (this.fSplashScreen.getOrientation().equalsIgnoreCase("landscape")) {
                this.fOrientation.select(0);
            } else if (this.fSplashScreen.getOrientation().equalsIgnoreCase("portrait")) {
                this.fOrientation.select(1);
            }
            this.fOperation.setText(this.fSplashScreen.getOperation());
            this.fResource.setInput(this.fSplashScreen.getSrc());
        } else {
            this.fSplashScreen = new TizenSplashScreen();
            this.fIndicatorDisplay.select(0);
            this.fResource.setInput(new Icon());
            this.fOperation.setText("");
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public void setSplashScreen(TizenSplashScreen sscreen) {
        this.fSplashScreen = sscreen;
    }

    public TizenSplashScreen getSplashScreen() {
        return this.fSplashScreen;
    }

    public Combo getType() {
        return this.fType;
    }

    public void setfype(Combo fType) {
        this.fType = fType;
    }

    public Combo getOrientation() {
        return this.fOrientation;
    }

    public void setOrientation(Combo fOrientation) {
        this.fOrientation = fOrientation;
    }

    public UiAttrImage getResource() {
        return this.fResource;
    }

    public void setResource(UiAttrImage fResource) {
        this.fResource = fResource;
    }

    class UiAttrImage
    extends UiAttrIcon {
        public UiAttrImage(TizenFormPage page) {
            super(page);
        }

        public UiAttrImage(TizenFormPage page, boolean mandatory) {
            super(page, mandatory);
        }

        public void addModifyListener(ModifyListener modifyListener) {
            this.getTextWidget().addModifyListener(modifyListener);
        }

        @Override
        public Text getTextWidget() {
            return super.getTextWidget();
        }
    }
}

