/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Description {
    public static final String ELEMENT = "description";
    public static final String ATTR_XMLLANG = "xml:lang";
    private String lang;
    private String value;

    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.lang = element.getAttribute(ATTR_XMLLANG);
        this.value = element.getTextContent();
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        parent.appendChild(element);
        if (this.getLang() != null && this.getLang().length() > 0) {
            element.setAttribute(ATTR_XMLLANG, this.getLang());
        }
        if (this.getValue() != null && this.getValue().length() > 0) {
            element.setTextContent(this.getValue());
        }
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

