/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.apichecker.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.tizen.nativecore.apichecker.APICheckerNature;

public class APCPropertyPage
extends PropertyPage {
    private IProject project;
    private Group fLaunchingGroup;
    private Button fLaunchingWithBuildButton;
    private Button fLaunchingWhileEditingButton;
    private Group fPrivilegeCheckGroup;
    private Button fUnusedPrivilegeCheckButton;
    public static final String WITH_BUILD = "apichecker.withbuild";
    public static final String WITH_EDIT = "apichecker.withedit";
    public static final String WITH_UNUSED_PRIVILEGE_CHECK = "apichecker.checkunused";
    public static final String APICHECKER_PROPERTIES_PAGE_ID = "apichecker.propertypage";
    public static final QualifiedName ENABLE_WITH_BUILD = new QualifiedName("apichecker.propertypage", "apichecker.withbuild");
    public static final QualifiedName ENABLE_WITH_EDITING = new QualifiedName("apichecker.propertypage", "apichecker.withedit");
    public static final QualifiedName ENABLE_UNUSED_PRIVILEGE_CHECK = new QualifiedName("apichecker.propertypage", "apichecker.checkunused");
    public static final String OPTION_ENABLE = "true";
    public static final String OPTION_DISABLE = "false";

    public APCPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fLaunchingGroup = new Group(composite, 0);
        layout = new GridLayout(1, false);
        layout.verticalSpacing = 5;
        layout.marginHeight = 5;
        this.fLaunchingGroup.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.fLaunchingGroup.setLayoutData((Object)gd);
        this.fLaunchingGroup.setText("Launching");
        this.fLaunchingWithBuildButton = new Button((Composite)this.fLaunchingGroup, 32);
        this.fLaunchingWithBuildButton.setText("Run API and privilege checks with build");
        this.fLaunchingWithBuildButton.setLayoutData((Object)new GridData(768));
        this.fLaunchingWhileEditingButton = new Button((Composite)this.fLaunchingGroup, 32);
        this.fLaunchingWhileEditingButton.setText("Run API and privilege checks while editing (check for unused privileges not available)");
        this.fLaunchingWhileEditingButton.setLayoutData((Object)new GridData(768));
        this.fPrivilegeCheckGroup = new Group(composite, 0);
        layout = new GridLayout(1, false);
        this.fPrivilegeCheckGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        this.fPrivilegeCheckGroup.setLayoutData((Object)gd);
        this.fPrivilegeCheckGroup.setText("Privilege Check");
        this.fUnusedPrivilegeCheckButton = new Button((Composite)this.fPrivilegeCheckGroup, 32);
        this.fUnusedPrivilegeCheckButton.setText("Unused privilege alarm");
        this.fUnusedPrivilegeCheckButton.setLayoutData((Object)new GridData(768));
        this.loadData();
        try {
            APICheckerNature.addNature(this.project, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void loadData() {
        if (this.project == null) {
            return;
        }
        this.fLaunchingWithBuildButton.setSelection(APCPropertyPage.getWithBuildOption(this.project));
        this.fLaunchingWhileEditingButton.setSelection(APCPropertyPage.getWithEditOption(this.project));
        this.fUnusedPrivilegeCheckButton.setSelection(APCPropertyPage.getWithUnusedPrivilegeOption(this.project));
    }

    public static void setWithBuildOption(IProject project, boolean option) {
        if (project == null) {
            return;
        }
        try {
            if (option) {
                project.setPersistentProperty(ENABLE_WITH_BUILD, OPTION_ENABLE);
            } else {
                project.setPersistentProperty(ENABLE_WITH_BUILD, OPTION_DISABLE);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public static boolean getWithBuildOption(IProject project) {
        if (project == null) {
            return false;
        }
        String option = null;
        try {
            option = project.getPersistentProperty(ENABLE_WITH_BUILD);
        }
        catch (CoreException coreException) {
            return false;
        }
        return OPTION_ENABLE.equals(option);
    }

    public static void setWithEditOption(IProject project, boolean option) {
        if (project == null) {
            return;
        }
        try {
            if (option) {
                project.setPersistentProperty(ENABLE_WITH_EDITING, OPTION_ENABLE);
            } else {
                project.setPersistentProperty(ENABLE_WITH_EDITING, OPTION_DISABLE);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public static boolean getWithEditOption(IProject project) {
        if (project == null) {
            return false;
        }
        String option = null;
        try {
            option = project.getPersistentProperty(ENABLE_WITH_EDITING);
        }
        catch (CoreException coreException) {
            return false;
        }
        return OPTION_ENABLE.equals(option);
    }

    public static void setWithUnusedPrivilegeOption(IProject project, boolean option) {
        if (project == null) {
            return;
        }
        try {
            if (option) {
                project.setPersistentProperty(ENABLE_UNUSED_PRIVILEGE_CHECK, OPTION_ENABLE);
            } else {
                project.setPersistentProperty(ENABLE_UNUSED_PRIVILEGE_CHECK, OPTION_DISABLE);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public static boolean getWithUnusedPrivilegeOption(IProject project) {
        if (project == null) {
            return false;
        }
        String option = null;
        try {
            option = project.getPersistentProperty(ENABLE_UNUSED_PRIVILEGE_CHECK);
        }
        catch (CoreException coreException) {
            return false;
        }
        return OPTION_ENABLE.equals(option);
    }

    protected boolean storeData() {
        if (this.project == null) {
            return false;
        }
        APCPropertyPage.setWithBuildOption(this.project, this.fLaunchingWithBuildButton.getSelection());
        APCPropertyPage.setWithEditOption(this.project, this.fLaunchingWhileEditingButton.getSelection());
        APCPropertyPage.setWithUnusedPrivilegeOption(this.project, this.fUnusedPrivilegeCheckButton.getSelection());
        return true;
    }

    public void performApply() {
        this.storeData();
        super.performApply();
    }

    public boolean performOk() {
        this.storeData();
        return super.performOk();
    }
}

