/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.tizen.nativecore.ext.manifest.Feature;
import org.tizen.nativecore.misc.editor.FeatureBaseDetailsPage;
import org.tizen.nativecore.misc.editor.FeatureManager;
import org.tizen.nativecore.misc.editor.FeaturesPage;

public class FeatureComboBasedDetailsPage
extends FeatureBaseDetailsPage {
    private Combo fCombo;
    private Label fLabel;
    private Feature.FEATURE_TYPE fFeatureType;

    public FeatureComboBasedDetailsPage(FeaturesPage page, Feature.FEATURE_TYPE type, FeatureManager featureManager) {
        super(page, featureManager);
        this.fFeatureType = type;
    }

    @Override
    protected void createContent(FormToolkit toolkit, Composite client) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureComboBasedDetailsPage.this.fPage.getEditor().getCoreManifest().addFeature(FeatureComboBasedDetailsPage.this.fInput.getKey(), FeatureComboBasedDetailsPage.this.fCombo.getText());
                FeatureComboBasedDetailsPage.this.fPage.setDirty(true);
            }
        };
        this.createSpacer(toolkit, client, 2);
        this.fLabel = toolkit.createLabel(client, "", 64);
        this.fCombo = this.fFeatureType == Feature.FEATURE_TYPE.FT_COMBO ? new Combo(client, 2056) : new Combo(client, 2048);
        this.fCombo.addSelectionListener((SelectionListener)listener);
        this.fCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!FeatureComboBasedDetailsPage.this.isUpdateMethodCalled) {
                    FeatureComboBasedDetailsPage.this.fPage.getEditor().getCoreManifest().addFeature(FeatureComboBasedDetailsPage.this.fInput.getKey(), FeatureComboBasedDetailsPage.this.fCombo.getText());
                    FeatureComboBasedDetailsPage.this.fPage.setDirty(true);
                    FeatureComboBasedDetailsPage.this.isUpdateMethodCalled = false;
                }
            }
        });
    }

    @Override
    protected void update() {
        if (this.fInput == null) {
            return;
        }
        this.isUpdateMethodCalled = true;
        boolean isValidOption = false;
        Feature feature = this.fInput;
        this.fSection.setText(String.valueOf(feature.getKey()) + " Details");
        this.fCombo.removeAll();
        this.fLabel.setText(feature.getDesc());
        String value = this.fPage.getEditor().getCoreManifest().getFeature(this.fInput.getKey());
        List<Feature.Option> options = feature.getOptions();
        int i = 0;
        while (i < options.size()) {
            Feature.Option o = options.get(i);
            this.fCombo.add(o.getValue());
            if (value.equals(o.getValue()) && this.fFeatureType == Feature.FEATURE_TYPE.FT_COMBO) {
                isValidOption = true;
            }
            ++i;
        }
        if (!isValidOption && this.fFeatureType == Feature.FEATURE_TYPE.FT_COMBO) {
            this.fPage.getEditor().getCoreManifest().addFeature(this.fInput.getKey(), "");
        }
        if (value != null) {
            this.fCombo.setText(value);
        }
    }
}

