/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkg.model;

import java.util.concurrent.CopyOnWriteArrayList;
import org.tizen.nativeplatform.pkg.model.PkgStatus;

public enum PackageProvider {
    INSTANCE;

    private CopyOnWriteArrayList<PkgStatus> buildsystem_pkgs = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<PkgStatus> device_pkgs = new CopyOnWriteArrayList();

    public void clear() {
        this.buildsystem_pkgs.clear();
        this.device_pkgs.clear();
    }

    public CopyOnWriteArrayList<PkgStatus> getBuildsystemPkgs() {
        return this.buildsystem_pkgs;
    }

    public CopyOnWriteArrayList<PkgStatus> getSelectedBuildsystemPkgs(boolean remove) {
        CopyOnWriteArrayList<PkgStatus> selectedList = new CopyOnWriteArrayList<PkgStatus>();
        for (PkgStatus pkg : this.buildsystem_pkgs) {
            if (!pkg.isChecked()) continue;
            if (remove && !pkg.getInstalledVer().isEmpty()) {
                selectedList.add(pkg);
                continue;
            }
            if (remove || pkg.getNewVer().isEmpty()) continue;
            selectedList.add(pkg);
        }
        return selectedList;
    }

    public CopyOnWriteArrayList<PkgStatus> getDevicePkgs() {
        return this.device_pkgs;
    }

    public CopyOnWriteArrayList<PkgStatus> getSelectedDevicePkgs(boolean remove) {
        CopyOnWriteArrayList<PkgStatus> selectedList = new CopyOnWriteArrayList<PkgStatus>();
        for (PkgStatus pkg : this.device_pkgs) {
            if (!pkg.isChecked()) continue;
            if (remove && !pkg.getInstalledVer().isEmpty()) {
                selectedList.add(pkg);
                continue;
            }
            if (remove || pkg.getNewVer().isEmpty()) continue;
            selectedList.add(pkg);
        }
        return selectedList;
    }
}

