/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.preferences.ui;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeplatform.pkg.tools.PkgcmdTool;
import org.tizen.nativeplatform.pkg.tools.RpmTool;
import org.tizen.nativeplatform.pkg.tools.ZypperTool;
import org.tizen.nativeplatform.preferences.DevicePreferencesManager;
import org.tizen.nativeplatform.preferences.PreferencesManager;

public class DevicePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor eflInstallOpField;
    private StringFieldEditor localPkgInstallOpField;
    private StringFieldEditor remotePkgInstallOpField;
    private Composite remoteDeviceComposite;
    private StringFieldEditor remoteDeviceHostnameField;
    private StringFieldEditor remoteDeviceIntervalField;

    public void init(IWorkbench workbench) {
        IPreferenceStore store = PreferencesManager.getPreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription("Device configuration");
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        SWTUtil.createSpacer((Composite)composite, (int)1);
        this.createLocalPackageToolComposite(composite);
        SWTUtil.createSpacer((Composite)composite, (int)1);
        this.createRemotePackageToolComposite(composite);
        SWTUtil.createSpacer((Composite)composite, (int)1);
        this.createDeviceAutoConnection(composite);
        if (OSChecker.isWindows()) {
            SWTUtil.createSpacer((Composite)composite, (int)1);
            this.createTransferMethodComposite(composite);
        }
    }

    private void createTransferMethodComposite(Composite parent) {
        Group comp = SWTUtil.createGroup((Composite)parent, (String)"Package Transfer Method", (int)1);
        Composite formatComposite = SWTUtil.createCompositeEx((Composite)comp, (int)1, (int)768);
        RadioGroupFieldEditor transferField = new RadioGroupFieldEditor("device.pkg.transfer", "", 2, (String[][])new String[][]{{"SDB", "sdb"}, {"SCP", "scp"}}, formatComposite);
        this.addField((FieldEditor)transferField);
    }

    private void createLocalPackageToolComposite(Composite parent) {
        Group comp = SWTUtil.createGroup((Composite)parent, (String)"Local Package Install Command", (int)1);
        Composite formatComposite = SWTUtil.createCompositeEx((Composite)comp, (int)1, (int)768);
        RadioGroupFieldEditor pkgToolField = new RadioGroupFieldEditor("device.local.pkg.install.tool", "Tool:", 3, (String[][])new String[][]{{"PKGCMD", "pkgcmd"}, {"RPM", "rpm"}, {"ZYPPER", "zypper"}}, formatComposite);
        this.addField((FieldEditor)pkgToolField);
        this.localPkgInstallOpField = new StringFieldEditor("device.local.pkg.install.op", "Install option:", formatComposite);
        this.addField((FieldEditor)this.localPkgInstallOpField);
    }

    private void createRemotePackageToolComposite(Composite parent) {
        Group comp = SWTUtil.createGroup((Composite)parent, (String)"Remote Package Install Command", (int)1);
        Composite formatComposite = SWTUtil.createCompositeEx((Composite)comp, (int)1, (int)768);
        RadioGroupFieldEditor pkgToolField = new RadioGroupFieldEditor("device.remote.pkg.install.tool", "Tool:", 2, (String[][])new String[][]{{"ZYPPER", "zypper"}}, formatComposite);
        this.addField((FieldEditor)pkgToolField);
        this.remotePkgInstallOpField = new StringFieldEditor("device.remote.pkg.install.op", "Install option:", formatComposite);
        this.addField((FieldEditor)this.remotePkgInstallOpField);
    }

    private void createDeviceAutoConnection(Composite parent) {
        Group comp = SWTUtil.createGroup((Composite)parent, (String)"Try to connect remote device repeatedly", (int)1);
        this.remoteDeviceComposite = SWTUtil.createCompositeEx((Composite)comp, (int)2, (int)768);
        BooleanFieldEditor enableOpField = new BooleanFieldEditor("device.remote.conn.enable", "Connect remote device", this.remoteDeviceComposite);
        enableOpField.fillIntoGrid(this.remoteDeviceComposite, 2);
        this.addField((FieldEditor)enableOpField);
        this.remoteDeviceHostnameField = new StringFieldEditor("device.remote.conn.hostname", "Remote hostname:", this.remoteDeviceComposite);
        this.addField((FieldEditor)this.remoteDeviceHostnameField);
        this.remoteDeviceIntervalField = new StringFieldEditor("device.remote.conn.interval", "Try interval(ms):", this.remoteDeviceComposite);
        this.addField((FieldEditor)this.remoteDeviceIntervalField);
        if (!DevicePreferencesManager.getDeviceRemoteConnectEnable()) {
            this.remoteDeviceHostnameField.setEnabled(false, this.remoteDeviceComposite);
            this.remoteDeviceIntervalField.setEnabled(false, this.remoteDeviceComposite);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof FieldEditor) {
            FieldEditor editor = (FieldEditor)event.getSource();
            String prefName = editor.getPreferenceName();
            if (prefName.equals("device.remote.conn.enable")) {
                if (event.getNewValue().equals(false)) {
                    this.remoteDeviceHostnameField.setEnabled(false, this.remoteDeviceComposite);
                    this.remoteDeviceIntervalField.setEnabled(false, this.remoteDeviceComposite);
                } else if (event.getNewValue().equals(true)) {
                    this.remoteDeviceHostnameField.setEnabled(true, this.remoteDeviceComposite);
                    this.remoteDeviceIntervalField.setEnabled(true, this.remoteDeviceComposite);
                }
            }
            if (prefName.equals("device.local.pkg.install.tool")) {
                if (event.getNewValue().equals("rpm")) {
                    this.localPkgInstallOpField.setStringValue(RpmTool.getInstallCommandFormat());
                } else if (event.getNewValue().equals("pkgcmd")) {
                    this.localPkgInstallOpField.setStringValue(PkgcmdTool.getInstallCommandFormat());
                } else if (event.getNewValue().equals("zypper")) {
                    this.localPkgInstallOpField.setStringValue(ZypperTool.getLocalInstallCommandFormat());
                }
            }
        }
        super.propertyChange(event);
    }
}

