/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.launch;

import java.io.File;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.launcher.command.provider.IRunCommandProvider;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;

public class RunCommandProvider
implements IRunCommandProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public File getRunningExec(ILaunchConfiguration config, IBinaryParser.IBinaryObject exeFile) throws CoreException {
        return exeFile.getPath().toFile();
    }

    public IPath getBinaryHostPath(PkgCommandTarget target, String appPath) throws CoreException {
        IPath hostPath = this.getHostPath(target, appPath);
        try {
            HostCommandLauncher.executeSudo((String)String.format("sudo chmod 755 %s", hostPath.toString()));
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return hostPath;
    }

    public IPath getHostPath(PkgCommandTarget target, String exePath) throws CoreException {
        Path path = new Path(target.getRootstrap().getPath());
        if (target.getRootstrapCommander() == null) {
            return new Path(exePath);
        }
        String canonicalPath = target.getRootstrapCommander().canonicalizePath(exePath);
        String rootstrapPath = SmartBuildInterface.getInstance().getPlatformRootstrapPath((IPath)path);
        if (rootstrapPath != null && !rootstrapPath.isEmpty()) {
            rootstrapPath = canonicalPath != null && !canonicalPath.isEmpty() ? rootstrapPath.concat(canonicalPath) : rootstrapPath.concat(exePath);
        }
        return new Path(rootstrapPath);
    }
}

