/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.rootstrap.action;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.rootstrap.util.PredefinedSnapshotXMLParser;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapGenWizard;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapGenWizardDialog;
import org.tizen.nativeplatform.types.PkgTypes;

public class ActionCreateRootstrap
extends Action {
    protected final String BUNDLE_NAME = String.valueOf(ActionCreateRootstrap.class.getPackage().getName()) + ".RootstrapUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    protected final Logger logger = LoggerFactory.getLogger(ActionCreateRootstrap.class);
    protected static final String PREREQUISITE_PKG = "ruby";
    protected Shell shell;
    protected boolean supportLocalrepo = true;

    public ActionCreateRootstrap(Shell shell) {
        this.shell = shell;
        this.setId(this.resources.getString("View.Add.Rootstrap.ToolTip"));
        this.setText(this.resources.getString("View.Add.Rootstrap.ToolTip"));
        Image img = ImageUtil.getImage((String)"org.tizen.nativeplatform.linux", (String)"icons/rootstrap/add.gif");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)img));
    }

    public void run() {
        PkgCommandTarget target = new PkgCommandTarget(PkgTypes.DPKG);
        IPkgCommander dpkgCommander = target.getHostCommander();
        if (!dpkgCommander.checkPkgInstalled(PREREQUISITE_PKG)) {
            String msg = String.format(this.resources.getString("GenRootDlg.Error.Miss.Prerequisite"), PREREQUISITE_PKG, PREREQUISITE_PKG);
            DialogUtil.openErrorDialog((String)msg);
            return;
        }
        HashMap snapshotMaps = new HashMap();
        List infos = InstallPathConfig.getProfileInfos();
        for (ProfileInfo info : infos) {
            String ver;
            String platformPath = InstallPathConfig.getPlatformPath((ProfileInfo)info, (String)(ver = info.getLatestPlatformVersion()));
            IPath snapshotXml = new Path(platformPath).append("predefined-snapshots").append("snapshots.xml");
            File xmlfile = snapshotXml.toFile();
            if (!xmlfile.exists()) continue;
            PredefinedSnapshotXMLParser parser = new PredefinedSnapshotXMLParser(xmlfile);
            Map snapshotMap = parser.getSnapshotMap();
            snapshotMaps.putAll(snapshotMap);
        }
        RootstrapGenWizard wizard = new RootstrapGenWizard(this.shell, snapshotMaps, this.supportLocalrepo);
        wizard.setWindowTitle(this.resources.getString("Wizard.Title"));
        RootstrapGenWizardDialog dlg = new RootstrapGenWizardDialog(this.shell, wizard);
        dlg.create();
        dlg.open();
    }
}

