/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FileUtil;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.linux.launch.RpmRapidDeployer;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.commander.deb.DebCommanderHost;
import org.tizen.nativeplatform.pkg.commander.rpm.RpmCommanderDevice;
import org.tizen.nativeplatform.pkg.commander.rpm.RpmCommanderHost;
import org.tizen.nativeplatform.pkg.commander.rpm.RpmCommanderRootstrap;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.rds.IRpmRapidDeployer;
import org.tizen.nativeplatform.types.PkgTypes;
import org.tizen.nativeplatform.util.ILaunchCommandUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.service.SyncResult;

public class LaunchCommandUtil
implements ILaunchCommandUtil {
    protected final Logger logger = LoggerFactory.getLogger(LaunchCommandUtil.class);

    public boolean copyFileToDevice(PlatformRootstrap rootstrap, IDevice device, String srcPath, String descPath) throws CoreException, TimeoutException, SdbCommandRejectedException, IOException {
        String path = new Path(descPath).removeLastSegments(1).toString();
        SyncResult syncResult = device.getSyncService().push(srcPath, device.getFileEntry(path));
        return syncResult.isOk();
    }

    public String winUploadCoredumpFile(String localPath) {
        return localPath;
    }

    public boolean winTransferSshKey(PkgCommandTarget target) {
        return true;
    }

    public String getUserHome() {
        return System.getProperty("user.name");
    }

    public String copyLocalfile(String srcPath, String dstPath) {
        try {
            String dstDirPath = new Path(dstPath).removeLastSegments(1).toString();
            FileUtil.createDirectory((File)new File(dstDirPath));
            FileUtil.copyTo((String)srcPath, (String)dstPath);
        }
        catch (IOException e) {
            this.logger.error(String.format("Faile to copy coredump file: %s -> %s", srcPath, dstPath));
            e.printStackTrace();
            return null;
        }
        return dstPath;
    }

    public IPkgCommander getHostCommander(PkgTypes type, boolean useConsoleLog) {
        if (type.equals((Object)PkgTypes.RPM)) {
            return new RpmCommanderHost(useConsoleLog);
        }
        if (type.equals((Object)PkgTypes.DPKG)) {
            return new DebCommanderHost();
        }
        return null;
    }

    public IPkgCommander getDeviceCommander(PkgTypes type, IDevice device, boolean useConsoleLog) {
        if (type.equals((Object)PkgTypes.RPM)) {
            return new RpmCommanderDevice(device);
        }
        return null;
    }

    public IPkgCommander getRootstrapCommander(PkgTypes type, PlatformRootstrap rootstrap, boolean useConsoleLog) {
        if (type.equals((Object)PkgTypes.RPM)) {
            Path basePath = new Path(rootstrap.getPath());
            String rootPath = SmartBuildInterface.getInstance().getPlatformRootstrapPath((IPath)basePath);
            return new RpmCommanderRootstrap((IPath)new Path(rootPath));
        }
        return null;
    }

    public IRpmRapidDeployer getRpmRapidDeployer(IProject project, IPkgCommander commander, List<IPackage> packages) {
        return new RpmRapidDeployer(project, commander, packages);
    }
}

