/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeplatform.model.Architecture;
import org.tizen.nativeplatform.repo.commander.RepoManager;
import org.tizen.nativeplatform.rootstrap.util.SnapshotParser;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapGenWizard;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapSettingPage2;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapSettingPage4;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapWizardData;

public class RootstrapGenWizard3
extends RootstrapGenWizard {
    public RootstrapGenWizard3(Shell shell, Map<String, List<String>> profileMap, boolean supportLocalRepo) {
        super(shell, profileMap, supportLocalRepo);
    }

    public RootstrapGenWizard3(Shell shell, Map<String, List<String>> profileMap, boolean supportLocalRepo, String defaultProfile) {
        super(shell, profileMap, supportLocalRepo, defaultProfile);
    }

    @Override
    public void addPages() {
        this.page1 = new RootstrapSettingPage4("setting_page1st", this.shell, this.project, this.config);
        this.page2 = new RootstrapSettingPage2("setting_page2nd", this.shell);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangedListener((IPageChangedListener)this);
        dialog.addPageChangingListener((IPageChangingListener)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handlePageChanging(final PageChangingEvent event) {
        WizardPage currentPage = (WizardPage)event.getCurrentPage();
        WizardPage targetPage = (WizardPage)event.getTargetPage();
        if (!currentPage.getName().equals("setting_page1st") || !targetPage.getName().equals("setting_page2nd")) return;
        if (RootstrapWizardData.isRemoteRepoEnabled()) {
            IWizardContainer container = this.getContainer();
            try {
                try {
                    container.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            int snapshotLength = RootstrapWizardData.getSnapshots().size();
                            monitor.beginTask(RootstrapGenWizard3.this.resources.getString("Wizard.Msg.Parse"), snapshotLength);
                            try {
                                this.setArchitectures(monitor);
                                this.setArchStrings();
                                if (RootstrapWizardData.getArchStrings().isEmpty()) {
                                    this.setDefaultArchs();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                SWTUtil.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        DialogUtil.openErrorDialog((String)e.getMessage());
                                    }
                                });
                                RootstrapGenWizard3.this.cancelChanging(event);
                            }
                        }

                        private boolean setArchitectures(IProgressMonitor monitor) throws MalformedURLException, IOException, InterruptedException {
                            RootstrapWizardData.getArchitectures().clear();
                            for (final String url : RootstrapWizardData.getSnapshots()) {
                                String protocol = new URL(url).getProtocol();
                                if (!RootstrapGenWizard3.this.isSupportedProtocol(protocol)) {
                                    SWTUtil.getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            DialogUtil.openErrorDialog((String)("Only support http and https:\n" + url));
                                        }
                                    });
                                    continue;
                                }
                                if (url.endsWith("packages") || url.endsWith("packages/") || url.endsWith("debug") || url.endsWith("debug/")) {
                                    RootstrapWizardData.addArchitectures(SnapshotParser.parsePkgUrl2(url, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                                    continue;
                                }
                                RootstrapWizardData.addArchitectures(SnapshotParser.parse(url, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                            }
                            return true;
                        }

                        private void setArchStrings() {
                            RootstrapWizardData.getArchStrings().clear();
                            for (Architecture arch : RootstrapWizardData.getArchitectures()) {
                                if (RootstrapWizardData.getArchStrings().contains(arch.getArch())) continue;
                                RootstrapWizardData.addArchString(arch.getArch());
                            }
                        }

                        private void setDefaultArchs() {
                            RootstrapWizardData.addArchString("armv7l");
                            RootstrapWizardData.addArchString("i586");
                        }
                    });
                    return;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    if (!event.doit) return;
                    this.page2.updatePageForRemoteRepo();
                    return;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    if (!event.doit) return;
                    this.page2.updatePageForRemoteRepo();
                    return;
                }
            }
            finally {
                if (event.doit) {
                    this.page2.updatePageForRemoteRepo();
                }
            }
        } else {
            String localRepoPath = RootstrapWizardData.getLocalrepoPath();
            RootstrapWizardData.getArchStrings().clear();
            List availableArchs = RepoManager.getValidator((String)localRepoPath).availableArchs();
            RootstrapWizardData.getArchStrings().addAll(availableArchs);
            this.page2.updatePageForLocalRepo();
        }
    }

    @Override
    public void cancelChanging(PageChangingEvent event) {
        event.doit = false;
    }
}

