/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.wizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.nativeplatform.repo.commander.RepoManager;
import org.tizen.nativeplatform.rootstrap.util.GBSConfFile;
import org.tizen.nativeplatform.rootstrap.util.GBSConfParser;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapSettingPage1;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapWizardData;

public class RootstrapSettingPage4
extends RootstrapSettingPage1 {
    private static final String FILTER_CONF = "*.conf";
    private static final String FILTER_ALL = "*.*";

    public RootstrapSettingPage4(String pageName, Shell shell, IProject project, IConfiguration config) {
        super(pageName, shell, project, config);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    @Override
    public void createPredefinedSnapshotContorl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(768);
        gridData.minimumHeight = 0;
        composite.setLayoutData((Object)gridData);
        Label lSnapshot = new Label(composite, 0);
        lSnapshot.setText(this.resources.getString("RemoteRepo.Predefined"));
        this.preDefinedSnapshotCombo = new Combo(composite, 8);
        GridData data = new GridData(768);
        this.preDefinedSnapshotCombo.setLayoutData((Object)data);
        this.preDefinedSnapshotCombo.setItems(this.predefinedSnapshots);
        int selection = 0;
        String defaultProfile = RootstrapWizardData.getDefaulatProfile();
        if (defaultProfile != null) {
            int i = 0;
            while (i < this.predefinedSnapshots.length) {
                if (defaultProfile.equals(this.predefinedSnapshots[i])) {
                    selection = i;
                    break;
                }
                ++i;
            }
        }
        this.preDefinedSnapshotCombo.select(selection);
        this.preDefinedSnapshotCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RootstrapSettingPage4.this.updatePredefinedSnapshot();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button browseBt = new Button(composite, 8);
        browseBt.setText(this.resources.getString("RootstrapPage4.Button.Browse"));
        browseBt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog fd = new FileDialog(RootstrapSettingPage4.this.getShell(), 4100);
                fd.setText(RootstrapSettingPage4.this.resources.getString("FileDlg.Title"));
                String[] filterExt = new String[]{RootstrapSettingPage4.FILTER_CONF, RootstrapSettingPage4.FILTER_ALL};
                fd.setFilterExtensions(filterExt);
                final String selectedFile = fd.open();
                final HashMap profileMap = new HashMap();
                if (selectedFile != null && !selectedFile.isEmpty()) {
                    IWizardContainer container = RootstrapSettingPage4.this.getContainer();
                    try {
                        container.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask((this).RootstrapSettingPage4.this.resources.getString("Action.Msg.Progress.GBSConf"), 2);
                                try {
                                    GBSConfFile confFile = GBSConfParser.parse(new File(selectedFile), monitor);
                                    if (confFile != null) {
                                        GBSConfFile.ProfileSection profileSection = confFile.generalSection.getProfileSection();
                                        if (profileSection == null) {
                                            throw new InterruptedException((this).RootstrapSettingPage4.this.resources.getString("Action.Msg.Error.FailedGetProfile"));
                                        }
                                        RootstrapWizardData.setDefaultProfile(profileSection.getName());
                                        monitor.worked(1);
                                        for (GBSConfFile.ProfileSection profSection : confFile.profileSections) {
                                            String name = profSection.getName();
                                            ArrayList<String> repoList = new ArrayList<String>();
                                            for (GBSConfFile.RepositorySection repoSection : profSection.getRepoSections()) {
                                                String value = repoSection.getConfiguration("url");
                                                String[] stringArray = value.split(",");
                                                int n = stringArray.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    String repo = stringArray[n2];
                                                    if (!RepoManager.isLocalUrl((String)(repo = repo.trim()))) {
                                                        repoList.add(repo);
                                                    }
                                                    ++n2;
                                                }
                                            }
                                            profileMap.put(name, repoList);
                                        }
                                        RootstrapWizardData.setProfileMap(profileMap);
                                        RootstrapSettingPage4.this.initPredefinedSnapshots();
                                    }
                                    monitor.worked(2);
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    RootstrapSettingPage4.this.preDefinedSnapshotCombo.setItems(RootstrapSettingPage4.this.predefinedSnapshots);
                    RootstrapSettingPage4.this.selectDefaultProfile();
                    RootstrapSettingPage4.this.clearTextControls();
                    RootstrapSettingPage4.this.createTextControls();
                    RootstrapSettingPage4.this.updatePredefinedSnapshot();
                    RootstrapSettingPage4.this.setMessage(String.format(RootstrapSettingPage4.this.resources.getString("RootstrapPage4.Msg.LoadedFile"), selectedFile));
                    RootstrapSettingPage4.this.snapshotComp.getParent().getParent().layout(true, true);
                }
            }
        });
    }
}

