/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.coredump;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkgmgr.PkgMgrInitializer;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.types.PkgInstallTypes;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;

public class CoredumpPreprocessor {
    private PkgCommandTarget target = null;
    private IPkgCommander commander = null;
    private List<String[]> requiredPackageInfo = new ArrayList<String[]>();
    private String log = "";
    private String errorMessage = "";

    public CoredumpPreprocessor() {
    }

    public CoredumpPreprocessor(PkgCommandTarget target) {
        this.target = target;
        this.commander = target.getCommander(CmdTargetTypes.ROOTSTRAP);
    }

    public void process(String crashPackage, List<String> solist, IProgressMonitor monitor) throws InterruptedException {
        if (this.target == null || this.commander == null) {
            throw new InterruptedException("Failed to set command target. Try to initialize a rootstrap again.");
        }
        monitor.beginTask("", 10);
        monitor.subTask("Progressing...");
        this.initRootstrap((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.checkCancelProcess(monitor);
        this.refreshRepositories((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.checkCancelProcess(monitor);
        this.installGdbPackage((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.checkCancelProcess(monitor);
        List<String> requiredPackages = this.getRequiredPackages(crashPackage, solist, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.checkCancelProcess(monitor);
        this.installPackages(requiredPackages, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.checkCancelProcess(monitor);
        List<String[]> packageInfo = this.getPackageInformation(requiredPackages, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.checkCancelProcess(monitor);
        List<String> debugPackages = this.getDebugPackages(requiredPackages, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.checkCancelProcess(monitor);
        this.installPackages(debugPackages, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.checkCancelProcess(monitor);
        List<String[]> debugPackageInfo = this.getPackageInformation(debugPackages, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.checkCancelProcess(monitor);
        this.requiredPackageInfo.addAll(packageInfo);
        this.requiredPackageInfo.addAll(debugPackageInfo);
    }

    public void setTarget(PkgCommandTarget target) {
        this.target = target;
        this.commander = target.getCommander(CmdTargetTypes.ROOTSTRAP);
    }

    public boolean changeRootstrap(PlatformRootstrap rootstrap) {
        if (this.target != null) {
            this.target.setRootstrap(rootstrap);
            this.commander = this.target.getCommander(CmdTargetTypes.ROOTSTRAP);
            return true;
        }
        return false;
    }

    public PlatformRootstrap generateRootstrap(String name, String arch, List<Repository> repos, IProgressMonitor monitor) throws InterruptedException {
        this.resetLogAndMessage();
        PlatformRootstrap newRootstrap = null;
        monitor.beginTask("", 2);
        monitor.subTask("Generating rootstrap...");
        try {
            if (RootstrapProxy.getProxy().existsRootstrap(name)) {
                this.errorMessage = String.format("\"%s\" rootstrap already exists.\nClick \"Select Rootstrap\" button.", name);
                throw new InterruptedException();
            }
            newRootstrap = RootstrapProxy.getProxy().generate(name, arch, "1.0", repos, true, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.worked(1);
            if (newRootstrap == null) {
                this.errorMessage = "Failed to generate a new rootstrap";
                throw new InterruptedException();
            }
            RootstrapProxy.getProxy().addRootstrap(newRootstrap);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return newRootstrap;
    }

    private void initRootstrap(IProgressMonitor monitor) throws InterruptedException {
        this.resetLogAndMessage();
        monitor.beginTask("", 1);
        monitor.subTask("Initializing rootstrap...");
        try {
            PkgMgrInitializer initializer = new PkgMgrInitializer(this.target);
            initializer.fastInitData((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    private void refreshRepositories(IProgressMonitor monitor) {
        monitor.beginTask("", 1);
        monitor.subTask("Refreshing repositories...");
        this.commander.refreshRepoList();
        monitor.worked(1);
        monitor.done();
    }

    private void installGdbPackage(IProgressMonitor monitor) throws InterruptedException {
        this.resetLogAndMessage();
        monitor.beginTask("", 1);
        monitor.subTask("Install \"gdb\" package...");
        try {
            this.commander.installRemotePkg("gdb", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!this.commander.checkPkgInstalled("gdb")) {
                this.log = this.commander.getLogs();
                this.errorMessage = "Failed to install \"gdb\" to rootstrap";
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }

    private List<String> getRequiredPackages(String crashPkg, List<String> solist, IProgressMonitor monitor) throws InterruptedException {
        this.resetLogAndMessage();
        monitor.beginTask("", solist.size());
        monitor.subTask("Getting provider packages...");
        ArrayList<String> requiredPackages = new ArrayList<String>();
        if (crashPkg != null) {
            requiredPackages.add(crashPkg);
        }
        requiredPackages.add("aul");
        requiredPackages.add("launchpad");
        try {
            for (String so : solist) {
                this.checkCancelProcess(monitor);
                monitor.subTask(String.format("Getting provider of %s", so));
                Map wp = this.commander.getWhatProvides(so, IPkgCommander.TOOL.ZYPPER);
                if (wp == null) {
                    monitor.worked(1);
                    continue;
                }
                for (String pkgName : wp.keySet()) {
                    if (requiredPackages.contains(pkgName)) continue;
                    requiredPackages.add(pkgName);
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
        return requiredPackages;
    }

    private void installPackages(List<String> pkglist, IProgressMonitor monitor) throws InterruptedException {
        this.resetLogAndMessage();
        monitor.beginTask("", pkglist.size());
        monitor.subTask("Install packages...");
        for (String pkg : pkglist) {
            this.checkCancelProcess(monitor);
            monitor.subTask(String.format("Install \"%s\" package...", pkg));
            this.commander.installRemotePkg(pkg, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
    }

    private List<String[]> getPackageInformation(List<String> pkglist, IProgressMonitor monitor) throws InterruptedException {
        this.resetLogAndMessage();
        ArrayList<String[]> requiredPkgInfo = new ArrayList<String[]>();
        monitor.beginTask("", pkglist.size());
        monitor.subTask("Getting package information...");
        for (String pkg : pkglist) {
            String[] info;
            String[] ver;
            if (pkg == null) continue;
            this.checkCancelProcess(monitor);
            monitor.subTask(String.format("Searching %s package", pkg));
            PkgInstallTypes installInfo = this.commander.searchPkg(pkg);
            if (installInfo.equals((Object)PkgInstallTypes.NOT_INSTALLED)) {
                ver = this.commander.getVer(pkg, IPkgCommander.TOOL.ZYPPER);
                info = new String[]{pkg, ver[0], PkgInstallTypes.NOT_INSTALLED.toString()};
                requiredPkgInfo.add(info);
            } else if (installInfo.equals((Object)PkgInstallTypes.INSTALLED)) {
                ver = this.commander.getVer(pkg, IPkgCommander.TOOL.RPM);
                info = new String[]{pkg, ver[0], PkgInstallTypes.INSTALLED.toString()};
                requiredPkgInfo.add(info);
            } else {
                String[] info2 = new String[]{pkg, "", PkgInstallTypes.NOT_EXISTS.toString()};
                requiredPkgInfo.add(info2);
            }
            monitor.worked(1);
        }
        monitor.done();
        return requiredPkgInfo;
    }

    private List<String> getDebugPackages(List<String> pkglist, IProgressMonitor monitor) throws InterruptedException {
        this.resetLogAndMessage();
        monitor.beginTask("", pkglist.size());
        monitor.subTask("Searching debug packages...");
        ArrayList<String> debugPackages = new ArrayList<String>();
        try {
            for (String pkg : pkglist) {
                String develPkg;
                this.checkCancelProcess(monitor);
                this.resetLogAndMessage();
                String[] debugPkgs = PlatformLaunchUtil.getDebugPackageName((IPkgCommander)this.commander, (String)pkg);
                if (!debugPackages.contains(debugPkgs[0])) {
                    debugPackages.add(debugPkgs[0]);
                }
                if (!debugPackages.contains(debugPkgs[1])) {
                    debugPackages.add(debugPkgs[1]);
                }
                if (!debugPackages.contains(develPkg = PlatformLaunchUtil.getDevelPackageName((IPkgCommander)this.commander, (String)pkg))) {
                    debugPackages.add(develPkg);
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
        return debugPackages;
    }

    private void checkCancelProcess(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            this.log = this.commander.getLogs();
            this.errorMessage = "Canceled Job";
            throw new InterruptedException();
        }
    }

    private void resetLogAndMessage() {
        this.log = "";
        this.errorMessage = "";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getLog() {
        return this.log;
    }

    public String getTotalLog() {
        if (this.commander == null) {
            return "";
        }
        return this.commander.getLogs();
    }

    public List<String[]> getRequiredPackageInfo() {
        return this.requiredPackageInfo;
    }
}

