/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;
import org.tizen.nativeplatform.rootstrap.util.DeviceRepoManager;
import org.tizen.nativeplatform.rootstrap.util.DeviceRepoParserException;
import org.tizen.nativeplatform.rootstrap.util.ZypperRepo;
import org.tizen.nativeplatform.util.PlatformFileUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.FileEntry;

public class DeviceRepoParser {
    private static final String ZYPPER_REPO_DIR = "/etc/zypp/repos.d";
    private static final String DEVICE_INFO_KEY = "%s (%s)";
    private static final String DEVICE_INFO_DIR = "device_info";
    public static final Logger logger = LoggerFactory.getLogger(DeviceRepoParser.class);
    private static final String BUNDLE_NAME = String.valueOf(DeviceRepoParser.class.getPackage().getName()) + ".DeviceRepoLoaderUIMessages";
    private static ResourceBundle resources = ResourceBundle.getBundle(BUNDLE_NAME);

    public static List<ZypperRepo> parse(IDevice device, IProgressMonitor monitor) throws DeviceRepoParserException {
        IPath deviceInfopath;
        monitor.beginTask(String.format(resources.getString("Progress.ParsingRepos"), device.getSerialNumber()), 2);
        FileEntry[] entries = device.getFileEntry(ZYPPER_REPO_DIR).getChildren();
        if (entries.length <= 0) {
            monitor.done();
            logger.error(String.format(resources.getString("Error.NoRepoFile"), device.getDeviceName()));
            return null;
        }
        monitor.subTask(resources.getString("Progress.PullingFiles"));
        String tmpDir = PlatformFileUtil.getTmpDir();
        if (tmpDir == null) {
            logger.error("Failed to get tmp dir");
            tmpDir = "";
        }
        if (!(deviceInfopath = new Path(tmpDir).append(DEVICE_INFO_DIR)).toFile().exists() && !deviceInfopath.toFile().mkdirs()) {
            monitor.done();
            String msg = String.format(resources.getString("Error.CreateDir"), deviceInfopath.toOSString());
            throw new DeviceRepoParserException(msg);
        }
        try {
            device.getSyncService().doPull(entries, deviceInfopath.toOSString(), null, 1000);
        }
        catch (IOException e) {
            monitor.done();
            throw new DeviceRepoParserException(resources.getString("Error.PullFiles"), e);
        }
        monitor.worked(1);
        monitor.subTask(resources.getString("Progress.ParsingFiles"));
        String arch = device.isEmulator() ? "i586" : "armv7l";
        ArrayList<ZypperRepo> repos = new ArrayList<ZypperRepo>();
        File[] flist = deviceInfopath.toFile().listFiles();
        if (flist != null) {
            File[] fileArray = flist;
            int n = flist.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ZypperRepo repo = DeviceRepoParser.readRepoFile(file);
                if (!repo.getBaseURL().isEmpty()) {
                    repo.setArch(arch);
                    repos.add(repo);
                }
                if (!file.delete()) {
                    logger.error("Failed to delete file: " + file.getAbsolutePath());
                }
                ++n2;
            }
        }
        monitor.worked(1);
        monitor.done();
        return repos;
    }

    public static void parse(IDevice[] devices, IProgressMonitor monitor) throws DeviceRepoParserException {
        if (devices != null) {
            monitor.beginTask("", devices.length);
            DeviceRepoManager.clear();
            try {
                IDevice[] iDeviceArray = devices;
                int n = devices.length;
                int n2 = 0;
                while (n2 < n) {
                    IDevice device = iDeviceArray[n2];
                    String serialNo = device.getSerialNumber();
                    String name = device.getDeviceName();
                    String key = String.format(DEVICE_INFO_KEY, serialNo, name);
                    List<ZypperRepo> repoData = DeviceRepoParser.parse(device, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (repoData != null) {
                        DeviceRepoManager.put(key, repoData);
                    }
                    ++n2;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private static ZypperRepo readRepoFile(File file) {
        ZypperRepo repo;
        block11: {
            repo = new ZypperRepo();
            InputStreamReader isr = null;
            BufferedReader reader = null;
            FileInputStream fs = null;
            try {
                fs = new FileInputStream(file);
                isr = new InputStreamReader((InputStream)fs, "UTF-8");
                reader = new BufferedReader(isr);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    int idx = line.indexOf(61);
                    if (idx <= 0) continue;
                    String key = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    if (key.equals(REPOINFO.name.name())) {
                        repo.setName(value);
                        continue;
                    }
                    if (key.equals(REPOINFO.failovermethod.name())) {
                        repo.setFailovermethod(value);
                        continue;
                    }
                    if (key.equals(REPOINFO.baseurl.name())) {
                        repo.setBaseURL(value);
                        continue;
                    }
                    if (key.equals(REPOINFO.gpgcheck.name())) {
                        repo.setGpgcheck(value);
                        continue;
                    }
                    if (!key.equals(REPOINFO.enabled.name())) continue;
                    repo.setEnabled(value);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                IOUtil.tryClose((Object[])new Object[]{fs, reader, isr});
                break block11;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{fs, reader, isr});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{fs, reader, isr});
                break block11;
            }
            IOUtil.tryClose((Object[])new Object[]{fs, reader, isr});
        }
        return repo;
    }

    private static enum REPOINFO {
        name,
        failovermethod,
        baseurl,
        gpgcheck,
        enabled;

    }
}

