/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.ui;

import java.util.ResourceBundle;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.nativeplatform.launcher.ui.PlatformCommonTab;
import org.tizen.nativeplatform.util.ProcessSelector;
import org.tizen.sdblib.IDevice;

public class PlatformMainAttachTab
extends PlatformCommonTab {
    private final String BUNDLE_NAME = String.valueOf(PlatformMainAttachTab.class.getPackage().getName()) + ".LaunchTabUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private Label fProcLabel;
    private Text fProcText;
    private Button fProcButton;
    private IDevice device = ConnectionPlugin.getDefault().getCurrentDevice();

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createProjectGroup(comp, 1);
        this.createProcessGroup(comp, 1);
        this.createOptionGroupComposite(comp);
        this.createVerticalSpacer(comp, 1);
    }

    private void createProcessGroup(Composite parent, int colSpan) {
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.fProcLabel = new Label(projComp, 0);
        this.fProcLabel.setText(this.resources.getString("Label.Proc.Name"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProcLabel.setLayoutData((Object)gd);
        this.fProcText = new Text(projComp, 2060);
        gd = new GridData(768);
        this.fProcText.setLayoutData((Object)gd);
        this.fProcText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PlatformMainAttachTab.this.fPreviouslyCheckedProgram = null;
                PlatformMainAttachTab.this.updateBuildConfigCombo("");
                PlatformMainAttachTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProcButton = this.createPushButton(projComp, this.resources.getString("Button.Find"), null);
        this.fProcButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ProcessSelector selector = new ProcessSelector(PlatformMainAttachTab.this.device);
                IProcessInfo procInfo = selector.getProcess(PlatformMainAttachTab.this.getShell());
                if (procInfo != null) {
                    Path ppath = new Path(procInfo.getName());
                    String name = ppath.lastSegment().trim();
                    PlatformMainAttachTab.this.fProcText.setText(name);
                }
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateProjectFromConfig(configuration);
        this.updateProcessFromConfig(configuration);
        this.updateReinstallOpFromConfig(configuration);
    }

    public boolean isValid(ILaunchConfiguration config) {
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        String name = this.fProjText.getText().trim();
        String procName = this.fProcText.getText().trim();
        boolean reinstallOp = this.fReinstallOp.getSelection();
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", name);
        config.setAttribute("org.tizen.platform.launch.PROCESS_NAME_ATTR", procName);
        config.setAttribute("org.tizen.platform.launch.REINSTALL_OP_ATTR", reinstallOp);
    }

    protected void updateProcessFromConfig(ILaunchConfiguration config) {
        String procName = "";
        try {
            procName = config.getAttribute("org.tizen.platform.launch.PROCESS_NAME_ATTR", "");
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log((Throwable)ce);
        }
        this.fProcText.setText(procName);
    }
}

