/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizard.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.launcher.factory.PkgFilterFactory;
import org.tizen.nativeplatform.launcher.rpm.IPkgFilter;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.util.IPackageUtil;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.nativeplatform.util.PlatformProjectUtil;

public class PlatformLaunchCommonPage
extends WizardPage {
    protected Button reinstallOp;
    protected IProject platformProject;
    protected IConfiguration config;
    protected List<IPackage> platformPackages = new ArrayList<IPackage>();
    protected List<IPackage> packages = new ArrayList<IPackage>();
    protected List<IPackage> devicePackages = new ArrayList<IPackage>();
    protected List<IPackage> rootstrapPackages = new ArrayList<IPackage>();
    protected PlatformRootstrap rootstrap;
    protected String rootPath = "";
    protected Shell shell;
    protected IPackageUtil pkgUtil = PlatformInstances.getPackageUtil();
    protected IPkgFilter pkgFilter = PkgFilterFactory.getFilter(PlatformProjectUtil.getPkgType());

    protected PlatformLaunchCommonPage(String pageName) {
        super(pageName);
    }

    protected PlatformLaunchCommonPage(String pageName, Shell shell, IProject project, IConfiguration config, PkgCommandTarget target) {
        super(pageName);
        this.platformProject = project;
        this.config = config;
        this.shell = shell;
        this.rootstrap = target.getRootstrap();
        if (this.rootstrap != null) {
            this.rootPath = SmartBuildInterface.getInstance().getPlatformRootstrapPath(this.rootstrap.getPath());
        }
    }

    public void createControl(Composite parent) {
    }

    protected List<IPackage> getPackages(IProject project, IConfiguration config) {
        return this.pkgUtil.getPackages(project, config);
    }

    protected void setPlatformPackages() {
        this.platformPackages.clear();
        this.platformPackages = this.getPackages(this.platformProject, this.config);
        if (!this.platformPackages.isEmpty()) {
            this.packages.addAll(this.platformPackages);
            this.devicePackages.addAll(this.pkgFilter.filter(CmdTargetTypes.DEVICE, this.packages));
            this.rootstrapPackages.addAll(this.pkgFilter.filter(CmdTargetTypes.ROOTSTRAP, this.packages));
        }
    }

    public List<IPackage> getPackages() {
        return this.packages;
    }

    public List<IPackage> getDevicePackages() {
        return this.devicePackages;
    }

    public List<IPackage> getRootstrapPackages() {
        return this.rootstrapPackages;
    }

    public boolean getReinstallOp() {
        if (this.reinstallOp == null) {
            return false;
        }
        return this.reinstallOp.getSelection();
    }

    public String getRootstrapPath() {
        return this.rootPath;
    }

    protected Shell getAvailableShell() {
        Shell shell = this.getShell();
        if (shell == null) {
            shell = PlatformLaunchUtil.getAvaiableShell();
        }
        return shell;
    }
}

