/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.command.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.common.util.IOUtil;
import org.tizen.nativeplatform.PlatformInstances;
import org.tizen.nativeplatform.pkg.commander.CommandStatus;
import org.tizen.nativeplatform.pkg.commander.ICommandStatus;
import org.tizen.nativeplatform.pkgmgr.PackageManagerOutputReceiver;

public class RootstrapCommandLauncher {
    public static ICommandStatus executeSudo(String command, String workingDir, PackageManagerOutputReceiver rec, IProgressMonitor monitor) {
        return RootstrapCommandLauncher.executeSudo(command, workingDir, null, rec, monitor);
    }

    public static ICommandStatus executeSudo(String command, String workingDir, Map<String, String> newEnv, PackageManagerOutputReceiver rec, IProgressMonitor monitor) {
        ICommandStatus status = null;
        String scriptCmd = PlatformInstances.getScriptProvider().genSudoExecuteScript(command);
        if (scriptCmd == null) {
            status = new CommandStatus(4, command, "Generating execution script failed!", null);
            return status;
        }
        status = RootstrapCommandLauncher.execute(scriptCmd, workingDir, newEnv, rec, monitor);
        PlatformInstances.getScriptProvider().cleanUpScript(scriptCmd);
        return status;
    }

    public static ICommandStatus execute(String command, String workingDir, PackageManagerOutputReceiver rec, IProgressMonitor monitor) {
        return RootstrapCommandLauncher.execute(command, workingDir, null, rec, monitor);
    }

    public static ICommandStatus execute(String command, String workingDir, Map<String, String> newEnv, PackageManagerOutputReceiver rec, IProgressMonitor monitor) {
        CommandStatus status = null;
        Process proc = null;
        ArrayList<String> log = new ArrayList<String>();
        try {
            block15: {
                proc = PlatformInstances.getBuildCommandUtil().createProcess(command, workingDir, newEnv, true);
                BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                try {
                    try {
                        while ((line = input.readLine()) != null) {
                            log.add(line);
                            if (rec != null && rec.getMsgConsoleStream() != null) {
                                rec.processNewLine(line);
                            }
                            if (monitor == null || !monitor.isCanceled()) continue;
                            if (rec != null) {
                                rec.processNewLine(String.format("Canceled command: %s", command));
                            }
                            throw new InterruptedException("Command execution is canceled!");
                        }
                    }
                    catch (IOException e) {
                        if (rec != null) {
                            rec.processNewLine(e.getMessage());
                        }
                        e.printStackTrace();
                        status = new CommandStatus(4, command, e.getMessage(), log, e);
                        if (input != null) {
                            IOUtil.tryClose((Object[])new Object[]{input});
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        IOUtil.tryClose((Object[])new Object[]{input});
                    }
                    throw throwable;
                }
                if (input != null) {
                    IOUtil.tryClose((Object[])new Object[]{input});
                }
            }
            proc.waitFor();
            if (monitor != null && monitor.isCanceled()) {
                status = new CommandStatus(4, command, "Command execution is canceled!", log, null);
                return status;
            }
        }
        catch (InterruptedException e) {
            status = new CommandStatus(4, command, e.getMessage(), log, e);
            return status;
        }
        status = new CommandStatus(0, proc.exitValue(), command, "Executed command", log, null);
        return status;
    }
}

