/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.manifest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.common.util.IOUtil;
import org.tizen.nativeplatform.IPlatformXMLStore;
import org.tizen.nativeplatform.filefilter.XmlFileFilter;
import org.tizen.nativeplatform.manifest.ApplicationData;
import org.tizen.nativeplatform.manifest.Messages;
import org.tizen.nativeplatform.manifest.PlatformManifestModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PlatformManifestXMLStore
implements IPlatformXMLStore {
    private static final String ELEMENT_MANIFEST = "manifest";
    private static final String ELEMENT_LABEL = "label";
    private static final String ELEMENT_APP = "ui-application";
    private static final String ATTR_APPID = "appid";
    private static final String ATTR_EXEC = "exec";
    private String projectPath;
    private List<File> manifestFiles = new ArrayList<File>();
    private List<PlatformManifestModel> models = new ArrayList<PlatformManifestModel>();
    private static final Logger logger = LoggerFactory.getLogger(PlatformManifestXMLStore.class);

    @Override
    public boolean loadXml() {
        if (!new File(this.projectPath).exists()) {
            logger.error(NLS.bind((String)Messages.PlatformXmlStore_PROJECT_NOT_EXIST, (Object)this.projectPath));
            this.clear();
            return false;
        }
        if (this.manifestFiles.isEmpty()) {
            logger.error(NLS.bind((String)Messages.PlatformXmlStore_MANIFEST_NOT_EXIST, (Object)this.projectPath));
            return false;
        }
        this.clear();
        for (File f : this.manifestFiles) {
            String filePath = f.getAbsolutePath();
            try {
                PlatformManifestModel model = this.loadXML(filePath);
                if (model == null) continue;
                this.models.add(model);
            }
            catch (IOException iOException) {
                this.models.clear();
                return false;
            }
            catch (SAXException sAXException) {
                this.models.clear();
                return false;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                this.models.clear();
                return false;
            }
        }
        return true;
    }

    private PlatformManifestModel loadXML(String path) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        File file;
        PlatformManifestModel model;
        FileInputStream stream;
        block3: {
            stream = null;
            model = null;
            try {
                file = new File(path);
                if (file.exists()) break block3;
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{stream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{stream});
            return null;
        }
        stream = new FileInputStream(file);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(stream);
        model = this.parse(dom);
        IOUtil.tryClose((Object[])new Object[]{stream});
        return model;
    }

    private PlatformManifestModel parse(Document dom) {
        Element root = dom.getDocumentElement();
        String rootName = root.getNodeName();
        PlatformManifestModel model = new PlatformManifestModel();
        if (rootName.equals(ELEMENT_MANIFEST)) {
            Node node = root.getFirstChild();
            while (node != null) {
                String nodeName = node.getNodeName();
                if (nodeName.equals(ELEMENT_LABEL)) {
                    model.setLabel(PlatformManifestXMLStore.getChildValue(node));
                } else if (nodeName.equals(ELEMENT_APP)) {
                    this.parseApp(node, model);
                }
                node = node.getNextSibling();
            }
        }
        return model;
    }

    private void parseApp(Node node, PlatformManifestModel model) {
        Element eNode = (Element)node;
        ApplicationData app = new ApplicationData();
        String appId = eNode.getAttribute(ATTR_APPID);
        String exec = eNode.getAttribute(ATTR_EXEC);
        app.setId(appId);
        app.setExec(exec);
        model.addAppData(app);
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public List<String> getIconFileList() {
        return null;
    }

    @Override
    public TizenProjectType getApplicationType() {
        return null;
    }

    @Override
    public List<String> getExecutableFiles() {
        ArrayList<String> exec = new ArrayList<String>();
        for (PlatformManifestModel m : this.models) {
            exec.addAll(m.getExecutableFiles());
        }
        return exec;
    }

    @Override
    public List<String> getAuthors() {
        return null;
    }

    @Override
    public void setProject(IProject project) {
        this.projectPath = project.getLocation().toString();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        File dir = project.getFile(defaultConfig.getName()).getLocation().toFile();
        String[] files = dir.list(new XmlFileFilter());
        if (files.length != 0) {
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                IPath filePath = project.getLocation().append(defaultConfig.getName()).append(file);
                this.manifestFiles.add(filePath.toFile());
                ++n2;
            }
        }
    }

    private void clear() {
        for (PlatformManifestModel m : this.models) {
            m.clear();
        }
    }

    private static String getChildValue(Node node) {
        if (node.getFirstChild() != null) {
            return node.getFirstChild().getNodeValue();
        }
        return null;
    }

    @Override
    public String getAppId(String programPath) {
        for (PlatformManifestModel m : this.models) {
            for (String exec : m.getExecutableFiles()) {
                if (!exec.equals(programPath)) continue;
                return m.getAppId();
            }
        }
        return "";
    }

    @Override
    public String[] getAppId() {
        ArrayList<String> idList = new ArrayList<String>();
        for (PlatformManifestModel m : this.models) {
            String id = m.getAppId();
            if (id == null || id.isEmpty()) continue;
            idList.add(id);
        }
        return idList.toArray(new String[0]);
    }
}

