/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.password;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.password.PasswordInputPage;
import org.tizen.nativeplatform.util.CommonBuildCommandUtil;

public class PasswordInputWizard
extends Wizard {
    private String password;
    private static final String BUNDLE_NAME = String.valueOf(PasswordInputWizard.class.getPackage().getName()) + ".PasswdDialogMessage";
    public static ResourceBundle resources = ResourceBundle.getBundle(BUNDLE_NAME);

    public PasswordInputWizard() {
        this.setWindowTitle("Input super-user password");
        this.setNeedsProgressMonitor(true);
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    public Image getDefaultPageImage() {
        return null;
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        PasswordInputPage page = (PasswordInputPage)this.getPage("password");
        if (page == null) {
            return false;
        }
        this.password = page.getPasswd();
        IWizardContainer container = this.getContainer();
        try {
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(resources.getString("Msg.Verify.Passwd"), -1);
                    boolean result = CommonBuildCommandUtil.verifySudoPasswd(PasswordInputWizard.this.password);
                    if (!result) {
                        throw new InterruptedException(resources.getString("Msg.Failed.Verify.Passwd"));
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            DialogUtil.openErrorDialog((String)e.toString());
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            DialogUtil.openErrorDialog((String)e.toString());
            return false;
        }
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)new PasswordInputPage("password"));
    }

    public String getPassword() {
        return this.password;
    }
}

