/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.PackageProvider;
import org.tizen.nativeplatform.repo.commander.LocalRepoMounter;
import org.tizen.nativeplatform.repo.commander.RepoManager;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.repo.model.RepositoryProvider;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.sdblib.IDevice;

public class PkgMgrInitializer {
    private PkgCommandTarget target = null;
    private PlatformRootstrap rootstrap = null;
    private IDevice device = null;
    private IPkgCommander rtCommander = null;
    private IPkgCommander dvCommander = null;

    public PkgMgrInitializer(PkgCommandTarget target) {
        this.target = target;
        if (target.isSetDevice()) {
            this.device = target.getDevice();
            this.dvCommander = target.getCommander(CmdTargetTypes.DEVICE);
        }
        if (target.isSetRootstrap()) {
            this.rootstrap = target.getRootstrap();
            this.rtCommander = target.getCommander(CmdTargetTypes.ROOTSTRAP);
        }
    }

    public PkgMgrInitializer(PkgCommandTarget target, CmdTargetTypes type) {
        this.target = target;
        if (type == CmdTargetTypes.DEVICE && target.isSetDevice()) {
            this.device = target.getDevice();
            this.dvCommander = target.getCommander(CmdTargetTypes.DEVICE);
        }
        if (type == CmdTargetTypes.ROOTSTRAP && target.isSetRootstrap()) {
            this.rootstrap = target.getRootstrap();
            this.rtCommander = target.getCommander(CmdTargetTypes.ROOTSTRAP);
        }
    }

    public void initRootstrapRepoInfo() {
        this.initRootstrapRepoInfo(true);
    }

    public void updateRootstrapRepoInfo() {
        if (this.isSetRootstrap()) {
            RepoManager.updateRepoInfoToRootstrap(this.target);
        }
    }

    public void updateRootstrapRepo() {
        if (this.isSetRootstrap()) {
            LocalRepoMounter.clearMounted(null);
            this.rtCommander.resetRepo();
            RepoManager.updateRepoToRootstrap(this.target);
        }
    }

    public void updateDeviceRepoInfo(List<Repository> repos) {
        if (this.isSetDevice()) {
            RepoManager.updateRepoInfoToDevice(repos);
        }
    }

    public void updateDeviceRepo() {
        if (this.isSetDevice()) {
            RepoManager.updateRepoToDevice(this.target);
        }
    }

    public void initRootstrapRepoInfo(boolean resetRepo) {
        if (this.isSetRootstrap()) {
            RepositoryProvider.INSTANCE.getBuildsystemRepos().clear();
            LocalRepoMounter.clearMounted(null);
            if (resetRepo) {
                this.rtCommander.resetRepo();
            }
            RepoManager.addReposToRootstrap(this.target);
        }
    }

    public void initDeviceRepoInfo() {
        if (this.isSetDevice()) {
            RepositoryProvider.INSTANCE.getDeviceRepos().clear();
            List<Repository> list = this.dvCommander.getRepoList();
            RepositoryProvider.INSTANCE.getDeviceRepos().addAll(list);
        }
    }

    public void initDeviceRepoInfo(List<Repository> repositories) {
        if (this.isSetDevice()) {
            this.dvCommander.resetRepo();
            int idx = 0;
            for (Repository repo : repositories) {
                String name = String.format("url%d", idx++);
                this.dvCommander.addRepo(name, repo.getUri());
            }
            this.initDeviceRepoInfo();
        }
    }

    public void initRepoInfo() {
        this.initRootstrapRepoInfo();
        this.initDeviceRepoInfo();
    }

    public void initRootstrapPkgInfo() {
        if (this.isSetRootstrap()) {
            PackageProvider.INSTANCE.getBuildsystemPkgs().clear();
            PackageProvider.INSTANCE.getBuildsystemPkgs().addAll(this.rtCommander.getAllPkgList());
        }
    }

    public void initDevicePkgInfo() {
        if (this.isSetDevice()) {
            PackageProvider.INSTANCE.getDevicePkgs().clear();
            PackageProvider.INSTANCE.getDevicePkgs().addAll(this.dvCommander.getAllPkgList());
        }
    }

    public void initPkgInfo() {
        this.initRootstrapPkgInfo();
        this.initDevicePkgInfo();
    }

    private boolean isSetRootstrap() {
        return this.rootstrap != null;
    }

    private boolean isSetDevice() {
        return this.device != null;
    }

    public void faskInitRootstrapData() {
        List<Repository> sourceList = this.rootstrap.getRepoList();
        List<Repository> targetList = this.target.getCommander(CmdTargetTypes.ROOTSTRAP).getRepoList();
        boolean needReset = true;
        if (sourceList.size() == targetList.size()) {
            for (Repository repo : targetList) {
                String url = repo.getUri();
                if (!this.rootstrap.containRepository(url)) {
                    needReset = true;
                    break;
                }
                needReset = false;
            }
        }
        this.initRootstrapRepoInfo(needReset);
        this.initRootstrapPkgInfo();
    }

    public void fastInitData(IProgressMonitor monitor) throws InterruptedException {
        if (this.isSetRootstrap()) {
            List<Repository> sourceList = this.rootstrap.getRepoList();
            List<Repository> targetList = this.target.getCommander(CmdTargetTypes.ROOTSTRAP).getRepoList();
            boolean needReset = true;
            if (sourceList.size() == targetList.size()) {
                for (Repository repo : targetList) {
                    String url = repo.getUri();
                    if (!this.rootstrap.containRepository(url)) {
                        needReset = true;
                        break;
                    }
                    needReset = false;
                }
            }
            this.initData(monitor, needReset);
        } else {
            this.initData(monitor, true);
        }
    }

    public void initData(IProgressMonitor monitor, boolean resetRepo) throws InterruptedException {
        if (monitor != null) {
            int totalworks = 2;
            if (this.isSetDevice()) {
                totalworks = 4;
            }
            monitor.beginTask("Initializing Package Manager...", totalworks);
            monitor.subTask("Intializing repositories on build system...");
            this.checkInterrupt(monitor);
            this.initRootstrapRepoInfo(resetRepo);
            this.checkInterrupt(monitor);
            monitor.worked(1);
            monitor.subTask("Intializing packages on build system...");
            this.initRootstrapPkgInfo();
            this.checkInterrupt(monitor);
            monitor.worked(2);
            if (this.isSetDevice()) {
                monitor.subTask("Intializing repositories on device...");
                this.initDeviceRepoInfo();
                this.checkInterrupt(monitor);
                monitor.worked(3);
                monitor.subTask("Intializing packages on device...");
                this.initDevicePkgInfo();
                this.checkInterrupt(monitor);
                monitor.worked(4);
            }
            monitor.done();
        } else {
            this.initRootstrapRepoInfo(resetRepo);
            this.initRootstrapPkgInfo();
            if (this.isSetDevice()) {
                this.initDeviceRepoInfo();
                this.initDevicePkgInfo();
            }
        }
    }

    private void checkInterrupt(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException("Canceled intializing.");
        }
    }
}

