/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.util;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.tizen.common.util.FileUtil;
import org.tizen.nativeplatform.util.PlatformFileUtil;

public class PlatformDirUtil {
    public static String DEFAULT_PLATFORM_COMMAND_DIR = "platform_command";
    public static String DEFAULT_PLATFORM_CACHING_DIR = "platform_cache";
    public static String DEFAULT_PLATFORM_COREDUMP_DIR = "platform_coredump";

    public static boolean clearCachingDir() {
        boolean result = FileUtil.recursiveDelete((File)new File(PlatformDirUtil.getCachingDir()));
        return result;
    }

    public static boolean clearWorkingDir() {
        boolean result = FileUtil.recursiveDelete((File)new File(PlatformDirUtil.getWorkingDir()));
        return result;
    }

    public static boolean clearCoredumpDir() {
        boolean result = FileUtil.recursiveDelete((File)new File(PlatformDirUtil.getCoredumpDir()));
        return result;
    }

    public static void clearPlatformTempDir() {
        PlatformDirUtil.clearCachingDir();
        PlatformDirUtil.clearWorkingDir();
        PlatformDirUtil.clearCoredumpDir();
    }

    public static String getCachingDir(IProject project) {
        return new Path(PlatformFileUtil.getTmpDir()).append(DEFAULT_PLATFORM_CACHING_DIR).append(project.getName()).toOSString();
    }

    public static String getCachingDir() {
        return new Path(PlatformFileUtil.getTmpDir()).append(DEFAULT_PLATFORM_CACHING_DIR).toOSString();
    }

    public static String getWorkingDir() {
        return new Path(PlatformFileUtil.getTmpDir()).append(DEFAULT_PLATFORM_COMMAND_DIR).toOSString();
    }

    public static String getCoredumpDir() {
        return new Path(PlatformFileUtil.getTmpDir()).append(DEFAULT_PLATFORM_COREDUMP_DIR).toOSString();
    }
}

