/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.builder.build;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativeplatform.builder.build.IBuildCommandProvider;
import org.tizen.nativeplatform.builder.build.IBuildResultProcessor;
import org.tizen.nativeplatform.builder.build.PlatformBuildCommandFactory;
import org.tizen.nativeplatform.builder.build.PlatformBuildMonitorThread;

public class PlatformBuildCommandLauncher
extends CommandLauncher {
    protected final String BUNDLE_NAME = String.valueOf(PlatformBuildCommandLauncher.class.getPackage().getName()) + ".PlatformBuildMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private static final String RPM_OUTPUT_STR = "**** RPM files ****";
    private static final String XML_OUTPUT_STR = "**** XML files ****";
    private static final String FAILED_SYNC_STR = "**** Failed to synchronize output files ****";
    private static final String FAILED_BUILD_STR = "**** Failed to build ****";
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private String[] buildargs;

    public Process execute(IPath commandPath, String[] args, String[] env, IPath changeToDirectory, IProgressMonitor monitor) throws CoreException {
        IProject proj = this.getProject();
        IConfiguration config = ManagedBuildManager.getBuildInfo((IResource)proj).getDefaultConfiguration();
        if (commandPath.toString().contains("platform_build")) {
            this.buildargs = args;
            IBuildCommandProvider provider = PlatformBuildCommandFactory.getProvider(config);
            if ("clean".equals(args[0])) {
                this.fProcess = provider.getCleanProcess(this, monitor);
                proj.touch(monitor);
                ProjectUtil.refreshResources((IProject)proj);
            } else {
                this.fProcess = provider.getBuildProcess(this, monitor);
            }
            provider = null;
        } else {
            this.fProcess = super.execute(commandPath, args, env, changeToDirectory, monitor);
        }
        PlatformBuildMonitorThread pmt = new PlatformBuildMonitorThread(this.fProcess, monitor);
        pmt.start();
        return this.fProcess;
    }

    public void setCommandArgs(String[] args) {
        this.fCommandArgs = args;
    }

    public int waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) {
        int result = super.waitAndRead(output, err, monitor);
        try {
            this.processBuildResult(output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (monitor.isCanceled()) {
            this.setErrorMessage(this.resources.getString("Build.error.cancel"));
        }
        return result;
    }

    private void processBuildResult(OutputStream consoleOutput) throws IOException {
        IProject proj = this.getProject();
        IConfiguration config = ManagedBuildManager.getBuildInfo((IResource)proj).getDefaultConfiguration();
        StringBuffer buf = new StringBuffer();
        int exitValue = this.fProcess.exitValue();
        if (exitValue == 0) {
            IBuildResultProcessor processor = PlatformBuildCommandFactory.getProcessor(config, IBuildCommandProvider.BUILDTOOL.GBS);
            if (processor.process(this.buildargs)) {
                if (!this.buildargs[0].equals("clean")) {
                    String file;
                    int n;
                    int n2;
                    String[] stringArray;
                    String[] rpmFiles = processor.getRpmFiles();
                    String[] xmlFiles = processor.getXmlFiles();
                    if (rpmFiles.length > 0) {
                        buf = new StringBuffer(NEWLINE);
                        buf.append(RPM_OUTPUT_STR).append(NEWLINE);
                        stringArray = rpmFiles;
                        n2 = rpmFiles.length;
                        n = 0;
                        while (n < n2) {
                            file = stringArray[n];
                            buf.append(" - ").append(file).append(NEWLINE);
                            ++n;
                        }
                    }
                    if (xmlFiles.length > 0) {
                        buf.append(NEWLINE);
                        buf.append(XML_OUTPUT_STR).append(NEWLINE);
                        stringArray = xmlFiles;
                        n2 = xmlFiles.length;
                        n = 0;
                        while (n < n2) {
                            file = stringArray[n];
                            buf.append(" - ").append(file).append(NEWLINE);
                            ++n;
                        }
                    }
                    consoleOutput.write(buf.toString().getBytes());
                }
            } else {
                buf = new StringBuffer(NEWLINE);
                buf.append(FAILED_SYNC_STR).append(NEWLINE);
                consoleOutput.write(buf.toString().getBytes());
            }
            processor = null;
        } else {
            buf = new StringBuffer(NEWLINE);
            buf.append(FAILED_BUILD_STR).append(NEWLINE);
            consoleOutput.write(buf.toString().getBytes());
        }
    }
}

