/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.rpm.core.RPMCorePlugin;
import org.eclipse.linuxtools.rpm.core.utils.Messages;
import org.eclipse.osgi.util.NLS;

public class FileDownloadJob
extends Job {
    private File file;
    private URLConnection content;

    public FileDownloadJob(File file, URLConnection content) {
        super(NLS.bind((String)Messages.DownloadJob_0, (Object)file.getName()));
        this.file = file;
        this.content = content;
    }

    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(NLS.bind((String)Messages.DownloadJob_0, (Object)this.file.getName()), this.content.getContentLength());
        try {
            int b;
            FileOutputStream fos = new FileOutputStream(this.file);
            BufferedInputStream is = new BufferedInputStream(this.content.getInputStream());
            while ((b = ((InputStream)is).read()) != -1) {
                if (monitor.isCanceled()) break;
                fos.write(b);
                monitor.worked(1);
            }
            ((InputStream)is).close();
            fos.close();
        }
        catch (IOException e) {
            RPMCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

