/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.changelog.core.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.linuxtools.changelog.core.editors.GNUElementScanner;

public class GNUFileEntryRule
implements IPredicateRule {
    protected IToken fileToken;
    protected IWordDetector fDetector = new IWordDetector(){

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c) || c == '/' || c == '.' || c == '-';
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierPart(c) || c == '/' || c == '.';
        }
    };
    private boolean started = false;
    private IWhitespaceDetector fWsDetector = new IWhitespaceDetector(){

        public boolean isWhitespace(char character) {
            return Character.isWhitespace(character);
        }
    };
    protected int fColumn = -1;
    protected static final int UNDEFINED = -1;
    private StringBuffer fBuffer = new StringBuffer();
    private String fStartingSequence = "* ";

    public GNUFileEntryRule(IToken fileToken) {
        this.fileToken = fileToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int c = scanner.read();
        this.fBuffer.setLength(0);
        if (!this.started) {
            int i = 0;
            while (i < this.fStartingSequence.length()) {
                this.fBuffer.append((char)c);
                if (this.fStartingSequence.charAt(i) != c) {
                    this.unreadBuffer(scanner);
                    return Token.UNDEFINED;
                }
                c = scanner.read();
                ++i;
            }
        } else if (c == 44) {
            this.fBuffer.append((char)c);
            c = scanner.read();
            while (c != -1 && this.fWsDetector.isWhitespace((char)c)) {
                this.fBuffer.append((char)c);
                c = scanner.read();
            }
            scanner.unread();
            return ((GNUElementScanner)scanner).getDefaultToken();
        }
        boolean haveFilePart = false;
        while (c != -1) {
            if (this.fDetector.isWordPart((char)c)) {
                this.fBuffer.append((char)c);
                haveFilePart = true;
            } else {
                if (c != 92) break;
                this.fBuffer.append((char)c);
                c = scanner.read();
                if (c == -1) {
                    this.unreadBuffer(scanner);
                    return Token.UNDEFINED;
                }
                this.fBuffer.append((char)c);
            }
            c = scanner.read();
        }
        if (!haveFilePart) {
            this.unreadBuffer(scanner);
            return Token.UNDEFINED;
        }
        if (c == 44) {
            this.started = true;
        }
        scanner.unread();
        return this.fileToken;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
        this.started = false;
    }

    public IToken getSuccessToken() {
        return this.fileToken;
    }
}

