/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.delegate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.launcher.LauncherInstances;
import org.tizen.nativeplatform.launcher.delegate.ILaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.factory.PkgFilterFactory;
import org.tizen.nativeplatform.launcher.message.PlatformLaunchMessages;
import org.tizen.nativeplatform.launcher.rpm.IPkgFilter;
import org.tizen.nativeplatform.launcher.rpm.RpmPackageLauncher;
import org.tizen.nativeplatform.launcher.wizards.PlatformAttachLaunchWizard;
import org.tizen.nativeplatform.launcher.wizards.PlatformLaunchWizardDialog;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.types.LaunchTypes;
import org.tizen.nativeplatform.util.IPackageUtil;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.nativeplatform.util.PlatformProjectUtil;

public class AttachLaunchConfigurationProcessor
implements ILaunchConfigurationProcessor {
    private ILaunchConfiguration launchConfig;
    private IProject project;
    private IConfiguration buildConfig;
    private String mode;
    private IProgressMonitor monitor;
    private Shell shell;
    private PkgCommandTarget target;
    private String applicationId = "";
    private IPackageUtil pkgUtil = LauncherInstances.getPackageUtil();
    private IPkgFilter pkgFilter = PkgFilterFactory.getFilter(PlatformProjectUtil.getPkgType());
    private String rootstrapInstallLog = "";
    private String deviceInstallLog = "";
    private boolean continueLaunch = true;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AttachLaunchConfigurationProcessor(Shell shell, ILaunchConfiguration launchConfig, IProject project, String mode, PkgCommandTarget target, IProgressMonitor monitor) {
        this.shell = shell;
        this.launchConfig = launchConfig;
        this.project = project;
        this.mode = mode;
        this.target = target;
        this.monitor = monitor;
        this.buildConfig = this.getBuildConfiguration();
    }

    @Override
    public boolean process() throws CoreException {
        boolean configurationIsSet = this.isSetProgramPath(this.launchConfig);
        LauncherInstances.getLaunchCommandUtil().winTransferSshKey(this.target);
        if (configurationIsSet) {
            return true;
        }
        this.monitor.beginTask("", 2);
        try {
            UserLogger.end((String)"platform.launch", (String)"pre.launch");
            if (!this.setLaunchConfiguration((IProgressMonitor)new SubProgressMonitor(this.monitor, 1))) {
                return false;
            }
        }
        finally {
            this.monitor.done();
        }
        return true;
    }

    private boolean _installPackages(List<IPackage> devicePkgs, List<IPackage> rootstrapPkgs, boolean reinstallOp, IProgressMonitor monitor) throws CoreException {
        block6: {
            int totalWorks = 1;
            monitor.beginTask("", totalWorks);
            RpmPackageLauncher pkgLauncher = new RpmPackageLauncher(this.project, this.target, devicePkgs, rootstrapPkgs, reinstallOp);
            try {
                try {
                    if (this.mode.equals("debug")) {
                        pkgLauncher.debugLaunchPkgs(LaunchTypes.NONE, this.shell, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        this.setSmackRule();
                        break block6;
                    }
                    pkgLauncher.launchPkgs(this.shell, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (InterruptedException e) {
                    this.newCoreException(PlatformLaunchMessages.FAILED_INSTALL_PKGS, e);
                    monitor.done();
                    this.rootstrapInstallLog = pkgLauncher.getRootstrapLog();
                    this.deviceInstallLog = pkgLauncher.getDeviceLog();
                }
            }
            finally {
                monitor.done();
                this.rootstrapInstallLog = pkgLauncher.getRootstrapLog();
                this.deviceInstallLog = pkgLauncher.getDeviceLog();
            }
        }
        return true;
    }

    private void setSmackRule() {
        String[] programPaths = PlatformLaunchUtil.getProgramPath((IProject)this.project);
        if (programPaths == null || programPaths.length <= 0) {
            return;
        }
        IPkgCommander commander = this.target.getDeviceCommander();
        StringBuffer pathlist = new StringBuffer();
        String[] stringArray = programPaths;
        int n = programPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            pathlist.append(path);
            pathlist.append(" ");
            ++n2;
        }
        String list = pathlist.toString().trim();
        Map smackInfo = PlatformLaunchUtil.getSmackInfo((IPkgCommander)commander, (String)list);
        if (smackInfo == null) {
            return;
        }
        for (String filepath : smackInfo.keySet()) {
            String[] labels = (String[])smackInfo.get(filepath);
            String a_label = labels[0];
            if (a_label != null && !a_label.isEmpty()) {
                commander.executeBinaryBySudo(this.getSmackRuleCommand(a_label));
            }
            commander.setSmackExecute(filepath, "\"\"");
        }
    }

    private String getSmackRuleCommand(String value) {
        value = value.replaceAll("\"", "");
        String cmd = String.format("echo \"sdbd::home %s rwx\" | smackload", value);
        return cmd;
    }

    private boolean setLaunchConfiguration(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        final ILaunchConfigurationWorkingCopy wc = this.launchConfig.getWorkingCopy();
        try {
            SWTUtil.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    boolean isPlatformVersion3 = false;
                    try {
                        isPlatformVersion3 = wc.getAttribute("org.tizen.platform.launch.TARGET_PLATFORM_VERSION", false);
                    }
                    catch (CoreException e) {
                        AttachLaunchConfigurationProcessor.this.logger.error("Failed to get platform version from config", (Throwable)e);
                    }
                    PlatformAttachLaunchWizard wizard = new PlatformAttachLaunchWizard(AttachLaunchConfigurationProcessor.this.shell, AttachLaunchConfigurationProcessor.this.launchConfig, AttachLaunchConfigurationProcessor.this.project, AttachLaunchConfigurationProcessor.this.buildConfig, AttachLaunchConfigurationProcessor.this.target, AttachLaunchConfigurationProcessor.this.mode, isPlatformVersion3);
                    PlatformLaunchWizardDialog dlg = new PlatformLaunchWizardDialog(AttachLaunchConfigurationProcessor.this.shell, wizard);
                    dlg.create();
                    if (dlg.open() == 0) {
                        String programPath = dlg.getProgramPath();
                        boolean reinstallOp = dlg.getReinstallOp();
                        boolean selectPkgOp = false;
                        String procName = dlg.getProcName();
                        int pid = dlg.getProcId();
                        AttachLaunchConfigurationProcessor.this.setOptionAttributes(wc, programPath, procName, pid, reinstallOp, selectPkgOp);
                    }
                }
            });
        }
        finally {
            monitor.done();
        }
        if (this.isSetProgramPath(this.launchConfig)) {
            if (this.applicationId != null && !this.applicationId.isEmpty()) {
                this.killIfRunningApplication(this.applicationId);
            }
            return true;
        }
        return false;
    }

    protected void setOptionAttributes(ILaunchConfigurationWorkingCopy wc, String programPath, String procName, int pid, boolean reinstallOp, boolean selectPkgOp) {
        if (programPath != null) {
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programPath);
        }
        wc.setAttribute("org.tizen.platform.launch.PROCESS_NAME_ATTR", procName);
        wc.setAttribute("org.tizen.platform.launch.PROCESS_ID_ATTR", pid);
        wc.setAttribute("org.tizen.platform.launch.REINSTALL_OP_ATTR", reinstallOp);
        try {
            wc.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
            e.printStackTrace();
        }
    }

    protected void setOptionAttributes(ILaunchConfigurationWorkingCopy wc, List<IPackage> devicePackages, List<IPackage> rootstrapPackages, boolean reinstallOp) {
        String tool;
        String path;
        HashMap<String, String> values;
        wc.setAttribute("org.tizen.platform.launch.REINSTALL_OP_ATTR", reinstallOp);
        if (devicePackages != null) {
            values = new HashMap<String, String>();
            for (IPackage p : devicePackages) {
                path = p.getPath();
                tool = p.getTool();
                if (tool == null || tool.isEmpty()) {
                    tool = "rpm";
                }
                values.put(path, tool);
            }
            wc.setAttribute("org.tizen.platform.launch.DEVICE_PACKAGE_LIST_ATTR", values);
        }
        if (rootstrapPackages != null) {
            values = new HashMap();
            for (IPackage p : rootstrapPackages) {
                path = p.getPath();
                tool = p.getTool();
                if (tool == null || tool.isEmpty()) {
                    tool = "rpm";
                }
                values.put(path, tool);
            }
            wc.setAttribute("org.tizen.platform.launch.ROOTSTRAP_PACKAGE_LIST_ATTR", values);
        }
        try {
            wc.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
            e.printStackTrace();
        }
    }

    protected boolean isSetProgramPath(ILaunchConfiguration wc) throws CoreException {
        String path = wc.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        return !path.isEmpty();
    }

    protected void killIfRunningApplication(String appId) throws CoreException {
        if (appId == null || appId.isEmpty()) {
            return;
        }
        IPkgCommander commander = this.target.getCommander(CmdTargetTypes.DEVICE);
        boolean isRunning = commander.isRunningApp(appId);
        if (isRunning) {
            commander.killApp(appId);
        }
    }

    protected void newCoreException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.tizen.nativeplatform", message, exception);
        throw new CoreException((IStatus)status);
    }

    protected IConfiguration getBuildConfiguration() {
        return PlatformConfigurationManager.getDefaultConfiguration((IProject)this.project);
    }

    protected boolean questionIfNoPackagesToInstall(List<IPackage> devicePackages, List<IPackage> rootstrapPackages) {
        final StringBuffer msg = new StringBuffer();
        if (devicePackages.isEmpty()) {
            msg.append("There is no package to install to device.");
            msg.append("\n");
        }
        if (this.mode.equals("debug") && rootstrapPackages.isEmpty()) {
            msg.append("There is no package to install to rootstrap.");
            msg.append("\n");
        }
        if (msg.length() != 0) {
            msg.append("\n");
            msg.append("Do you want to continue?");
            SWTUtil.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (DialogUtil.openQuestionDialog((String)msg.toString()) == 64) {
                        AttachLaunchConfigurationProcessor.this.continueLaunch = true;
                    } else {
                        AttachLaunchConfigurationProcessor.this.continueLaunch = false;
                    }
                }
            });
        }
        return this.continueLaunch;
    }
}

