/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizard.pages;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.nativeplatform.launcher.rpm.RpmDebugPackagesResolver;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchCommonPage;
import org.tizen.nativeplatform.launcher.wizards.PlatformLaunchWizard;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkgmgr.PkgMgrInitializer;
import org.tizen.nativeplatform.pkgmgr.ui.RPMPackageDialog;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.sdblib.service.FileEntry;

public class PlatformLaunchSettingPage
extends PlatformLaunchCommonPage {
    private final String BUNDLE_NAME = String.valueOf(PlatformLaunchSettingPage.class.getPackage().getName()) + ".LaunchWizardPageUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    protected PlatformLaunchWizard wizard;
    protected String mode;
    protected PkgCommandTarget cmdTarget;
    protected String commandInitText = "";
    protected String argumentsInitText = "";
    protected boolean findDebugPkg;
    protected boolean isDebug;
    protected String COMMAND_LABEL_TEXT = "Command:";
    protected Button autoLibButton;
    protected Text commandText;
    protected Text argumentsText;
    protected Color originColor;
    protected final String DEBUGGER_COMMAND = "/usr/bin/gdb";
    protected final String LAUNCH_APP_COMMAND = "/usr/bin/launch_app";
    protected final String GUIDE_STRING = "Ex) /opt/apps/org.tizen.eflapp/bin/eflapp";
    protected final String DEBUG_GUIDE_STRING = "Please input binary using \"Browse\" button";

    public PlatformLaunchSettingPage(PlatformLaunchWizard wizard, Shell shell, String pageName, IProject project, IConfiguration config, PkgCommandTarget cmdTarget, String mode) {
        super(pageName, shell, project, config, cmdTarget);
        this.setTitle(this.resources.getString("EFLBinPage.Title"));
        this.setDescription(this.resources.getString("EFLBinPage.Desc"));
        this.setPlatformPackages();
        this.wizard = wizard;
        this.mode = mode;
        this.cmdTarget = cmdTarget;
        this.commandInitText = "Ex) /opt/apps/org.tizen.eflapp/bin/eflapp";
        this.originColor = wizard.getShell().getForeground();
        this.isDebug = mode.equals("debug");
        if (this.isDebug) {
            this.commandInitText = "Please input binary using \"Browse\" button";
            this.COMMAND_LABEL_TEXT = "Executable file:";
        }
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.createInfoComposite(composite);
        this.createRunCommandComposite(composite, true);
        if (this.isDebug) {
            this.createDebugOptionComposite(composite, true);
        }
        this.setControl((Control)composite);
    }

    protected void createInfoComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData(768);
        Button logBt = new Button(composite, 8);
        logBt.setText("View internal log");
        logBt.setLayoutData((Object)gridData);
        logBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PlatformLaunchSettingPage.this.wizard.openLogTabDialog();
            }
        });
        Button setEnvBt = new Button(composite, 8);
        setEnvBt.setText("Set environments");
        setEnvBt.setLayoutData((Object)gridData);
        setEnvBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PlatformLaunchSettingPage.this.wizard.openSetEnvDialog();
            }
        });
        Button pkgMgrBt = new Button(composite, 8);
        pkgMgrBt.setText("Install other packages");
        pkgMgrBt.setLayoutData((Object)gridData);
        pkgMgrBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PlatformLaunchSettingPage.this.handleClickPackageManager();
            }
        });
    }

    protected void createRunCommandComposite(Composite parent, boolean useGuideString) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        GridData spanData = new GridData(768);
        spanData.horizontalSpan = 2;
        Label binaryLabel = new Label(composite, 0);
        binaryLabel.setText(this.COMMAND_LABEL_TEXT);
        this.commandText = this.isDebug ? new Text(composite, 2060) : new Text(composite, 2052);
        GridData data = new GridData(768);
        this.commandText.setLayoutData((Object)data);
        if (useGuideString) {
            this.commandText.setForeground(this.wizard.getShell().getDisplay().getSystemColor(16));
            this.commandText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    PlatformLaunchSettingPage.this.commandText.setForeground(PlatformLaunchSettingPage.this.originColor);
                    String value = PlatformLaunchSettingPage.this.commandText.getText();
                    if (value.equals("Ex) /opt/apps/org.tizen.eflapp/bin/eflapp") || value.equals("Please input binary using \"Browse\" button")) {
                        PlatformLaunchSettingPage.this.commandText.setText("");
                    }
                }

                public void focusLost(FocusEvent e) {
                }
            });
        }
        this.commandText.setText(this.commandInitText);
        this.commandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PlatformLaunchSettingPage.this.validateDebugPackage();
            }
        });
        Button browseButton = new Button(composite, 8);
        browseButton.setText(this.resources.getString("BinPage.Button.Browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path = PlatformLaunchSettingPage.this.handleBrowseButtonSelected();
                if (path != null && !path.isEmpty()) {
                    PlatformLaunchSettingPage.this.commandText.setForeground(PlatformLaunchSettingPage.this.originColor);
                    PlatformLaunchSettingPage.this.commandText.setText(path);
                }
            }
        });
        Label argumentsLabel = new Label(composite, 0);
        argumentsLabel.setText("Arguments:");
        this.argumentsText = new Text(composite, 2052);
        this.argumentsText.setLayoutData((Object)spanData);
        this.argumentsText.setText(this.argumentsInitText);
    }

    protected void createDebugOptionComposite(Composite parent, boolean enableLoadSymbol) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(768));
        this.autoLibButton = new Button(composite, 32);
        this.autoLibButton.setText("Load shared library symbols automatically");
        this.autoLibButton.setSelection(enableLoadSymbol);
    }

    public void validate() {
        String command = this.commandText.getText().trim();
        String projName = this.platformProject.getName();
        if (command.isEmpty() || command.equals("Ex) /opt/apps/org.tizen.eflapp/bin/eflapp") || command.equals("Please input binary using \"Browse\" button")) {
            if (this.isDebug) {
                String msg = String.format("Input executable file to debug \"%s\" project", projName);
                this.pageNotCompleted(msg);
            } else {
                String msg = String.format("Input command to test \"%s\" project", projName);
                this.pageNotCompleted(msg);
            }
            return;
        }
        if (command.contains(" ")) {
            this.pageNotCompleted("Command contains an argument.");
            return;
        }
        IPkgCommander deviceCommander = this.cmdTarget.getDeviceCommander();
        if (deviceCommander == null) {
            String msg = "Please check to connect device";
            this.pageNotCompleted(msg);
            return;
        }
        if (!deviceCommander.existsFile(command)) {
            String msg = String.format("\"%s\" does not exist on the device.", command);
            this.pageNotCompleted(msg);
            return;
        }
        this.pageCompleted();
    }

    protected void validateDebugPackage() {
        final String command = this.commandText.getText().trim();
        if (command.isEmpty()) {
            return;
        }
        if (this.mode.equals("debug")) {
            IPkgCommander rootstrapCommander = this.cmdTarget.getRootstrapCommander();
            if (rootstrapCommander == null) {
                return;
            }
            this.findDebugPkg = true;
            IWizardContainer container = this.getContainer();
            try {
                container.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        RpmDebugPackagesResolver resolver = new RpmDebugPackagesResolver(PlatformLaunchSettingPage.this.cmdTarget, monitor);
                        PlatformLaunchSettingPage.this.findDebugPkg = resolver.resolve(command);
                    }
                });
            }
            catch (Exception e1) {
                this.wizard.openErrorDialog(e1.toString());
                e1.printStackTrace();
            }
            if (!rootstrapCommander.existsFile(command)) {
                String msg = String.format("\"%s\" does not exist on the rootstrap. The binary should be in the rootstrap", command);
                this.pageNotCompleted(msg);
                return;
            }
            if (!this.findDebugPkg) {
                String msg = "Failed to find debug packages or install packages";
                this.pageCompleted(msg, true);
                return;
            }
            if (command.startsWith("/opt/usr/apps/")) {
                String recommend = command.replaceAll("/opt/usr/apps/", "/opt/apps/");
                String msg = String.format("Debugging can be failed if you use the command. Recommand using \"%s\" command", command, recommend);
                this.pageCompleted(msg, true);
                return;
            }
        }
        this.pageCompleted();
    }

    protected void pageNotCompleted(String errorMsg) {
        this.setErrorMessage(errorMsg);
        this.setPageComplete(false);
        this.wizard.setEnableFinish(false);
        this.wizard.getContainer().updateButtons();
    }

    protected void pageCompleted(String msg, boolean isError) {
        this.setErrorMessage(null);
        if (isError) {
            this.setErrorMessage(msg);
        } else {
            this.setMessage(msg, 0);
        }
        this.setPageComplete(true);
        this.wizard.setEnableFinish(true);
        this.wizard.getContainer().updateButtons();
    }

    protected void pageCompleted() {
        this.pageCompleted("Click Finish button", false);
    }

    public String getBinaryPath() {
        return this.commandText.getText().trim();
    }

    public String getArguments() {
        return this.argumentsText.getText().trim();
    }

    public boolean loadSharedLibAutomatically() {
        if (this.autoLibButton == null) {
            return false;
        }
        return this.autoLibButton.getSelection();
    }

    public String getSelectedApp() {
        return null;
    }

    protected String handleBrowseButtonSelected() {
        Shell shell = this.getAvailableShell();
        FileEntry path = PlatformLaunchUtil.selectRemoteFile((Shell)shell, (String)this.resources.getString("BinPage.Remote.Dialog.Title"), (String)"/opt/apps");
        if (path != null) {
            return path.getFullPath();
        }
        return null;
    }

    protected void handleClickPackageManager() {
        IWizardContainer container = this.getContainer();
        final PkgMgrInitializer initializer = new PkgMgrInitializer(this.cmdTarget);
        try {
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 1);
                    monitor.subTask("Initializing Package Manager...");
                    try {
                        initializer.fastInitData((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            RPMPackageDialog dlg = new RPMPackageDialog(this.shell, this.cmdTarget);
            dlg.open();
            this.validate();
        }
        catch (Exception e1) {
            this.wizard.openErrorDialog(e1.toString());
            e1.printStackTrace();
        }
    }
}

