/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizard.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchCommonPage;
import org.tizen.nativeplatform.launcher.wizards.PlatformCoredumpLaunchWizard;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.rootstrap.IRootstrapManager;
import org.tizen.nativeplatform.rootstrap.RootstrapInstances;

public class PlatformLaunchSettingRootstrapPage2
extends PlatformLaunchCommonPage {
    private final String BUNDLE_NAME = String.valueOf(PlatformLaunchSettingRootstrapPage2.class.getPackage().getName()) + ".LaunchWizardPageUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);
    private PlatformCoredumpLaunchWizard wizard = null;
    private List<PlatformRootstrap> rootstraps = new ArrayList<PlatformRootstrap>();
    private List<String> rootstrapList = new ArrayList<String>();
    private List<String> repositoryList = new ArrayList<String>();
    private String selectedRootstrapName;
    private TableViewer repoTable;
    private Combo rootstrapCombo;
    private Label rootstrapLabel;
    private Text rootstrapText;
    protected final Logger logger = LoggerFactory.getLogger(PlatformLaunchSettingRootstrapPage2.class);

    public PlatformLaunchSettingRootstrapPage2(PlatformCoredumpLaunchWizard wizard, String pageName, Shell shell, IProject project, IConfiguration config, PkgCommandTarget target) {
        super(pageName, shell, project, config, target);
        this.wizard = wizard;
        this.setTitle(this.resources.getString("RtPage.Title"));
        this.setDescription(this.resources.getString("RtPage.Desc"));
        this.setPageComplete(false);
    }

    public static List<PlatformRootstrap> getArmRootstrap() {
        ArrayList<PlatformRootstrap> list = new ArrayList<PlatformRootstrap>();
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        if (iRootstrapManager != null) {
            for (PlatformRootstrap r : iRootstrapManager.getRootstraps()) {
                String arch = r.getArchitecture();
                if (!PlatformConfigurationManager.containValue((String[])PlatformConfigurationManager.ARCHGROUP_ARM, (String)arch)) continue;
                list.add(r);
            }
        }
        return list;
    }

    public static List<PlatformRootstrap> getX86Rootstrap() {
        ArrayList<PlatformRootstrap> list = new ArrayList<PlatformRootstrap>();
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        if (iRootstrapManager != null) {
            for (PlatformRootstrap r : iRootstrapManager.getRootstraps()) {
                String arch = r.getArchitecture();
                if (!PlatformConfigurationManager.containValue((String[])PlatformConfigurationManager.ARCHGROUP_X86, (String)arch)) continue;
                list.add(r);
            }
        }
        return list;
    }

    public void updateRootstrapData() {
        PlatformRootstrap rootstrap;
        this.rootstrapList.clear();
        this.rootstraps.clear();
        if (this.wizard.getCoredumpModel() != null) {
            List<PlatformRootstrap> list;
            if (this.wizard.getCoredumpModel().isX86coredump()) {
                this.rootstrapLabel.setText("Rootstrap (i586): ");
                list = PlatformLaunchSettingRootstrapPage2.getX86Rootstrap();
                for (PlatformRootstrap r : list) {
                    if (!r.checkInitialized()) continue;
                    this.rootstraps.add(r);
                }
            } else if (this.wizard.getCoredumpModel().isArmcoredump()) {
                this.rootstrapLabel.setText("Rootstrap (armv7l): ");
                list = PlatformLaunchSettingRootstrapPage2.getArmRootstrap();
                for (PlatformRootstrap r : list) {
                    if (!r.checkInitialized()) continue;
                    this.rootstraps.add(r);
                }
            }
        }
        for (PlatformRootstrap r : this.rootstraps) {
            this.rootstrapList.add(r.getName());
        }
        this.rootstrapCombo.setItems(this.rootstrapList.toArray(new String[0]));
        this.rootstrapCombo.select(0);
        this.selectedRootstrapName = this.rootstrapCombo.getText().trim();
        if (this.selectedRootstrapName != null && !this.selectedRootstrapName.isEmpty() && (rootstrap = this.getRootstrap(this.selectedRootstrapName)) != null) {
            List repos = rootstrap.getJustRepoURLs();
            this.UpdateRepos(repos);
        }
    }

    private PlatformRootstrap getRootstrap(String name) {
        for (PlatformRootstrap r : this.rootstraps) {
            if (!name.equals(r.getName())) continue;
            return r;
        }
        return null;
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createSelectRootstrapComposite(composite);
        this.createTableComposite(composite);
        this.setControl((Control)composite);
    }

    private void createSelectRootstrapComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.rootstrapLabel = new Label(composite, 0);
        this.rootstrapLabel.setText("Rootstraps (armv7l): ");
        GridData gridData = new GridData(768);
        this.rootstrapCombo = new Combo(composite, 8);
        this.rootstrapCombo.setLayoutData((Object)gridData);
        this.rootstrapCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PlatformLaunchSettingRootstrapPage2.this.selectedRootstrapName = PlatformLaunchSettingRootstrapPage2.this.rootstrapCombo.getText().trim();
                PlatformRootstrap rootstrap = PlatformLaunchSettingRootstrapPage2.this.getRootstrap(PlatformLaunchSettingRootstrapPage2.this.selectedRootstrapName);
                if (rootstrap != null) {
                    List repos = rootstrap.getJustRepoURLs();
                    PlatformLaunchSettingRootstrapPage2.this.UpdateRepos(repos);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 100;
        gridData.heightHint = 100;
        composite.setLayoutData((Object)gridData);
        this.createRepositoryTable(composite);
    }

    private void createRepositoryTable(Composite parent) {
        Composite t_composite = new Composite(parent, 0);
        t_composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        t_composite.setLayout((Layout)layout);
        this.repoTable = new TableViewer(t_composite, 2304);
        Table table = this.repoTable.getTable();
        GridData tableGridData = new GridData(1808);
        table.setLayoutData((Object)tableGridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{"Repositories"};
        int[] columnWidths = new int[]{1000};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setText(columnNames[i]);
            tableColumn.setWidth(columnWidths[i]);
            tableColumn.setResizable(true);
            ++i;
        }
        this.repoTable.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void UpdateRepos(List<String> data) {
        this.repoTable.setInput(data);
        this.repositoryList.clear();
        this.repositoryList.addAll(data);
        if (this.validPageComplete()) {
            this.setErrorMessage(null);
            this.setMessage(String.format(this.resources.getString("RtPage.Msg.GetRepo"), this.repositoryList.size()));
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(this.resources.getString("RtPage.ErrorMsg.FailedGetRepo"));
            this.setPageComplete(false);
        }
    }

    private boolean validPageComplete() {
        int repoSize = this.repositoryList.size();
        int tableCount = this.repoTable.getTable().getItemCount();
        return tableCount > 0 && repoSize == tableCount;
    }

    public List<String> getRepositryList() {
        return this.repositoryList;
    }

    public String getRootstrapName() {
        return this.rootstrapText.getText();
    }

    public PlatformRootstrap getSelectedRootstrap() {
        return this.getRootstrap(this.selectedRootstrapName);
    }
}

