/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.tizen.nativeplatform.launcher.factory.PkgFilterFactory;
import org.tizen.nativeplatform.launcher.rpm.IPkgFilter;
import org.tizen.nativeplatform.launcher.rpm.RpmPackageLauncher;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformEFLLaunchSettingPage;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchSettingPage;
import org.tizen.nativeplatform.launcher.wizard.pages.PlatformLaunchSettingPkgPage;
import org.tizen.nativeplatform.launcher.wizards.PlatformCommonLaunchWizard;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.IPackage;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.types.LaunchTypes;
import org.tizen.nativeplatform.util.PlatformProjectUtil;

public class PlatformLaunchWizard
extends PlatformCommonLaunchWizard {
    private boolean isEFL;
    private IPkgFilter pkgFilter;
    private static final String SETTING_PKG_PAGE = "setting_pkg";
    private static final String SETTING_BIN_PAGE = "setting_bin";

    public PlatformLaunchWizard() {
    }

    public PlatformLaunchWizard(Shell shell, ILaunchConfiguration launchConfig, IProject project, IConfiguration config, PkgCommandTarget target, String mode, boolean isEFL, boolean isPlatformVersion3) {
        super(shell, launchConfig, project, config, target, mode);
        this.isPlatformVersion3 = isPlatformVersion3;
        this.isEFL = isEFL;
        this.pkgFilter = PkgFilterFactory.getFilter(PlatformProjectUtil.getPkgType());
    }

    @Override
    public boolean performFinish() {
        PlatformLaunchSettingPage binPage = null;
        binPage = this.isEFL ? (PlatformEFLLaunchSettingPage)this.getPage(SETTING_BIN_PAGE) : (PlatformLaunchSettingPage)this.getPage(SETTING_BIN_PAGE);
        if (binPage != null) {
            this.programPath = binPage.getBinaryPath();
            this.arguments = binPage.getArguments();
            this.selectedApp = binPage.getSelectedApp();
            this.loadSharedLib = binPage.loadSharedLibAutomatically();
        }
        return true;
    }

    @Override
    public void addPages() {
        PlatformLaunchSettingPkgPage page1 = new PlatformLaunchSettingPkgPage(this, this.shell, SETTING_PKG_PAGE, this.project, this.config, this.target);
        if (this.mode.equals("run")) {
            page1.disableRootstrapGroup();
        }
        this.addPage((IWizardPage)page1);
        if (this.isEFL) {
            this.addPage((IWizardPage)new PlatformEFLLaunchSettingPage(this, this.shell, SETTING_BIN_PAGE, this.project, this.config, this.target, this.mode));
        } else {
            this.addPage((IWizardPage)new PlatformLaunchSettingPage(this, this.shell, SETTING_BIN_PAGE, this.project, this.config, this.target, this.mode));
        }
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangedListener((IPageChangedListener)this);
        dialog.addPageChangingListener((IPageChangingListener)this);
    }

    @Override
    public void pageChanged(PageChangedEvent event) {
        WizardPage currentPage = (WizardPage)event.getSelectedPage();
        if (currentPage.getName().equals(SETTING_PKG_PAGE)) {
            this.getContainer().updateButtons();
        }
    }

    @Override
    public void handlePageChanging(PageChangingEvent event) {
        WizardPage currentPage = (WizardPage)event.getCurrentPage();
        WizardPage targetPage = (WizardPage)event.getTargetPage();
        if (currentPage.getName().equals(SETTING_PKG_PAGE) && targetPage.getName().equals(SETTING_BIN_PAGE)) {
            PlatformLaunchSettingPkgPage pkgPage = (PlatformLaunchSettingPkgPage)currentPage;
            PlatformLaunchSettingPage settingPage = (PlatformLaunchSettingPage)targetPage;
            pkgPage.savePkgInstallInfo();
            final List<IPackage> checkedDevicePkgs = pkgPage.getCheckedDevicePackage();
            final List<IPackage> checkedRootstrapPkgs = pkgPage.getCheckedRootstrapPackage();
            IWizardContainer container = this.getContainer();
            try {
                container.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        block10: {
                            monitor.beginTask("", 1);
                            PlatformLaunchWizard.this.deviceLog = "";
                            PlatformLaunchWizard.this.rootstrapLog = "";
                            PlatformLaunchWizard.this.devicePackages.clear();
                            PlatformLaunchWizard.this.rootstrapPackages.clear();
                            try {
                                PlatformLaunchWizard.this.launchConfig.getWorkingCopy();
                            }
                            catch (CoreException e1) {
                                e1.printStackTrace();
                                new InterruptedException(e1.getMessage());
                            }
                            if (checkedDevicePkgs != null && !checkedDevicePkgs.isEmpty()) {
                                PlatformLaunchWizard.this.devicePackages.addAll(PlatformLaunchWizard.this.pkgFilter.filter(CmdTargetTypes.DEVICE, checkedDevicePkgs));
                            }
                            if (checkedRootstrapPkgs != null && !checkedRootstrapPkgs.isEmpty()) {
                                PlatformLaunchWizard.this.rootstrapPackages.addAll(PlatformLaunchWizard.this.pkgFilter.filter(CmdTargetTypes.ROOTSTRAP, checkedRootstrapPkgs));
                            }
                            PlatformLaunchWizard.this.reinstallOp = true;
                            RpmPackageLauncher pkgLauncher = new RpmPackageLauncher(PlatformLaunchWizard.this.project, PlatformLaunchWizard.this.target, PlatformLaunchWizard.this.devicePackages, PlatformLaunchWizard.this.rootstrapPackages, PlatformLaunchWizard.this.reinstallOp);
                            try {
                                try {
                                    if (PlatformLaunchWizard.this.mode.equals("debug")) {
                                        pkgLauncher.debugLaunchPkgs(LaunchTypes.NONE, PlatformLaunchWizard.this.shell, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                        break block10;
                                    }
                                    pkgLauncher.launchPkgs(PlatformLaunchWizard.this.shell, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                                catch (InterruptedException e) {
                                    new InterruptedException(e.getMessage());
                                    monitor.done();
                                    PlatformLaunchWizard.this.rootstrapLog = pkgLauncher.getRootstrapLog();
                                    PlatformLaunchWizard.this.deviceLog = pkgLauncher.getDeviceLog();
                                }
                            }
                            finally {
                                monitor.done();
                                PlatformLaunchWizard.this.rootstrapLog = pkgLauncher.getRootstrapLog();
                                PlatformLaunchWizard.this.deviceLog = pkgLauncher.getDeviceLog();
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                this.openErrorDialog(e.toString());
                this.cancelChanging(event);
            }
            settingPage.validate();
        }
    }
}

