/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.nativecommon.build.CommonBuildTargetManager;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativeplatform.PlatformBuildTargetManager;
import org.tizen.nativeplatform.PlatformResourceChangeListener;
import org.tizen.nativeplatform.RemoteLogger;
import org.tizen.nativeplatform.preferences.PreferencesManager;
import org.tizen.nativeplatform.util.PlatformDirUtil;
import org.tizen.sdblib.util.IOUtil;

public class Activator
extends AbstractUIPlugin {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "org.tizen.nativeplatform";
    public static final String REMOTE_DEVICE_LIST_FILE = String.valueOf(InstallPathConfig.getUserDataPath()) + File.separator + "ide" + File.separator + "remote_device.list";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        RemoteLogger.sendStart();
        PlatformDirUtil.clearPlatformTempDir();
        PreferencesManager.setDefaultValues();
        PlatformResourceChangeListener listener = new PlatformResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 4);
        String[] projectTypes = new String[]{"org.tizen.nativeide.buildArtefactType.platform"};
        CommonConfigurationManager.registerBuildTargetManager((String[])projectTypes, (CommonBuildTargetManager)new PlatformBuildTargetManager());
    }

    public void addDefaultRemoteDeivce() {
        block6: {
            File file = new File(REMOTE_DEVICE_LIST_FILE);
            if (file.exists()) {
                return;
            }
            String deviceInfo = "HyperUART TV/192.168.250.250/26101";
            BufferedWriter out = null;
            try {
                try {
                    out = new BufferedWriter(new FileWriter(REMOTE_DEVICE_LIST_FILE));
                    out.write(deviceInfo);
                    out.newLine();
                }
                catch (IOException e) {
                    logger.debug("Failed to write default remote device information", (Throwable)e);
                    IOUtil.tryClose((Closeable)out);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(out);
                throw throwable;
            }
            IOUtil.tryClose((Closeable)out);
        }
    }

    public static ImageDescriptor getImageDescriptorFromPlugin(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        RemoteLogger.sendStop();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getPluginId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }
}

