/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PredefinedSnapshotXMLParser {
    public static final String XML_PREFIX = "<?xml";
    public static final String NEW_LINE = "\n";
    private Document doc = null;

    public PredefinedSnapshotXMLParser() {
    }

    public PredefinedSnapshotXMLParser(Document doc) {
        this.setDoc(doc);
    }

    public PredefinedSnapshotXMLParser(File xmlFile) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        if (dbf != null) {
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                this.doc = db.parse(xmlFile);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setDoc(Document doc) {
        this.doc = doc;
    }

    public Map<String, List<String>> getSnapshotMap() {
        HashMap<String, List<String>> list = new HashMap<String, List<String>>();
        if (this.doc == null) {
            return list;
        }
        this.doc.getDocumentElement().normalize();
        NodeList repoNodes = this.doc.getElementsByTagName("snapshot");
        int i = 0;
        while (i < repoNodes.getLength()) {
            String name = "";
            ArrayList<String> urls = new ArrayList<String>();
            Node repoNode = repoNodes.item(i);
            NamedNodeMap snapshotMap = repoNode.getAttributes();
            Node snapshotItem = snapshotMap.getNamedItem("name");
            if (snapshotItem != null) {
                name = snapshotItem.getNodeValue();
                NodeList urlNodes = repoNode.getChildNodes();
                int j = 0;
                while (j < urlNodes.getLength()) {
                    NamedNodeMap urlMap;
                    Node urlItem;
                    Node urlNode = urlNodes.item(j);
                    if (urlNode.getNodeName().equals("url") && (urlItem = (urlMap = urlNode.getAttributes()).getNamedItem("value")) != null) {
                        urls.add(urlItem.getNodeValue());
                    }
                    ++j;
                }
                if (name != null && !name.isEmpty() && !urls.isEmpty()) {
                    list.put(name, new ArrayList(urls));
                }
                urls.clear();
            }
            ++i;
        }
        return list;
    }
}

